/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexruntime.model.IntentConfidence;
import software.amazon.awssdk.services.lexruntime.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PredictedIntent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PredictedIntent> {
    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PredictedIntent.getter(PredictedIntent::intentName)).setter(PredictedIntent.setter(Builder::intentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentName").build()}).build();
    private static final SdkField<IntentConfidence> NLU_INTENT_CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PredictedIntent.getter(PredictedIntent::nluIntentConfidence)).setter(PredictedIntent.setter(Builder::nluIntentConfidence)).constructor(IntentConfidence::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nluIntentConfidence").build()}).build();
    private static final SdkField<Map<String, String>> SLOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(PredictedIntent.getter(PredictedIntent::slots)).setter(PredictedIntent.setter(Builder::slots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slots").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_NAME_FIELD, NLU_INTENT_CONFIDENCE_FIELD, SLOTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String intentName;
    private final IntentConfidence nluIntentConfidence;
    private final Map<String, String> slots;

    private PredictedIntent(BuilderImpl builder) {
        this.intentName = builder.intentName;
        this.nluIntentConfidence = builder.nluIntentConfidence;
        this.slots = builder.slots;
    }

    public String intentName() {
        return this.intentName;
    }

    public IntentConfidence nluIntentConfidence() {
        return this.nluIntentConfidence;
    }

    public boolean hasSlots() {
        return this.slots != null && !(this.slots instanceof SdkAutoConstructMap);
    }

    public Map<String, String> slots() {
        return this.slots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.intentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nluIntentConfidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.slots());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictedIntent)) {
            return false;
        }
        PredictedIntent other = (PredictedIntent)obj;
        return Objects.equals(this.intentName(), other.intentName()) && Objects.equals(this.nluIntentConfidence(), other.nluIntentConfidence()) && Objects.equals(this.slots(), other.slots());
    }

    public String toString() {
        return ToString.builder((String)"PredictedIntent").add("IntentName", (Object)this.intentName()).add("NluIntentConfidence", (Object)this.nluIntentConfidence()).add("Slots", (Object)(this.slots() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "intentName": {
                return Optional.ofNullable(clazz.cast(this.intentName()));
            }
            case "nluIntentConfidence": {
                return Optional.ofNullable(clazz.cast(this.nluIntentConfidence()));
            }
            case "slots": {
                return Optional.ofNullable(clazz.cast(this.slots()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PredictedIntent, T> g) {
        return obj -> g.apply((PredictedIntent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String intentName;
        private IntentConfidence nluIntentConfidence;
        private Map<String, String> slots = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PredictedIntent model) {
            this.intentName(model.intentName);
            this.nluIntentConfidence(model.nluIntentConfidence);
            this.slots(model.slots);
        }

        public final String getIntentName() {
            return this.intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        public final IntentConfidence.Builder getNluIntentConfidence() {
            return this.nluIntentConfidence != null ? this.nluIntentConfidence.toBuilder() : null;
        }

        @Override
        public final Builder nluIntentConfidence(IntentConfidence nluIntentConfidence) {
            this.nluIntentConfidence = nluIntentConfidence;
            return this;
        }

        public final void setNluIntentConfidence(IntentConfidence.BuilderImpl nluIntentConfidence) {
            this.nluIntentConfidence = nluIntentConfidence != null ? nluIntentConfidence.build() : null;
        }

        public final Map<String, String> getSlots() {
            return this.slots;
        }

        @Override
        public final Builder slots(Map<String, String> slots) {
            this.slots = StringMapCopier.copy(slots);
            return this;
        }

        public final void setSlots(Map<String, String> slots) {
            this.slots = StringMapCopier.copy(slots);
        }

        public PredictedIntent build() {
            return new PredictedIntent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PredictedIntent> {
        public Builder intentName(String var1);

        public Builder nluIntentConfidence(IntentConfidence var1);

        default public Builder nluIntentConfidence(Consumer<IntentConfidence.Builder> nluIntentConfidence) {
            return this.nluIntentConfidence((IntentConfidence)((IntentConfidence.Builder)IntentConfidence.builder().applyMutation(nluIntentConfidence)).build());
        }

        public Builder slots(Map<String, String> var1);
    }
}

