/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexruntime.model.PostTextRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PostTextRequestModelMarshaller {
    private static final MarshallingInfo<String> BOTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("botName").isBinary(false).build();
    private static final MarshallingInfo<String> BOTALIAS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("botAlias").isBinary(false).build();
    private static final MarshallingInfo<String> USERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("userId").isBinary(false).build();
    private static final MarshallingInfo<Map> SESSIONATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sessionAttributes").isBinary(false).build();
    private static final MarshallingInfo<Map> REQUESTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestAttributes").isBinary(false).build();
    private static final MarshallingInfo<String> INPUTTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputText").isBinary(false).build();
    private static final PostTextRequestModelMarshaller INSTANCE = new PostTextRequestModelMarshaller();

    private PostTextRequestModelMarshaller() {
    }

    public static PostTextRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PostTextRequest postTextRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)postTextRequest), (String)"postTextRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)postTextRequest.botName(), BOTNAME_BINDING);
            protocolMarshaller.marshall((Object)postTextRequest.botAlias(), BOTALIAS_BINDING);
            protocolMarshaller.marshall((Object)postTextRequest.userId(), USERID_BINDING);
            protocolMarshaller.marshall(postTextRequest.sessionAttributes(), SESSIONATTRIBUTES_BINDING);
            protocolMarshaller.marshall(postTextRequest.requestAttributes(), REQUESTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)postTextRequest.inputText(), INPUTTEXT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

