/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntime.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.lexruntime.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ResponseCard JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ResponseCardUnmarshaller implements Unmarshaller<ResponseCard, JsonUnmarshallerContext> {

    public ResponseCard unmarshall(JsonUnmarshallerContext context) throws Exception {
        ResponseCard.Builder responseCardBuilder = ResponseCard.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("version", targetDepth)) {
                    context.nextToken();
                    responseCardBuilder.version(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("contentType", targetDepth)) {
                    context.nextToken();
                    responseCardBuilder.contentType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("genericAttachments", targetDepth)) {
                    context.nextToken();
                    responseCardBuilder.genericAttachments(new ListUnmarshaller<GenericAttachment>(GenericAttachmentUnmarshaller
                            .getInstance()).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return responseCardBuilder.build();
    }

    private static final ResponseCardUnmarshaller INSTANCE = new ResponseCardUnmarshaller();

    public static ResponseCardUnmarshaller getInstance() {
        return INSTANCE;
    }
}
