/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntime.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.lexruntime.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * PostTextResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PostTextResponseUnmarshaller implements Unmarshaller<PostTextResponse, JsonUnmarshallerContext> {

    public PostTextResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        PostTextResponse.Builder postTextResponseBuilder = PostTextResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return postTextResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("intentName", targetDepth)) {
                    context.nextToken();
                    postTextResponseBuilder.intentName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("slots", targetDepth)) {
                    context.nextToken();
                    postTextResponseBuilder.slots(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class),
                            context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("sessionAttributes", targetDepth)) {
                    context.nextToken();
                    postTextResponseBuilder.sessionAttributes(new MapUnmarshaller<String, String>(context
                            .getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("message", targetDepth)) {
                    context.nextToken();
                    postTextResponseBuilder.message(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("messageFormat", targetDepth)) {
                    context.nextToken();
                    postTextResponseBuilder.messageFormat(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("dialogState", targetDepth)) {
                    context.nextToken();
                    postTextResponseBuilder.dialogState(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("slotToElicit", targetDepth)) {
                    context.nextToken();
                    postTextResponseBuilder.slotToElicit(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("responseCard", targetDepth)) {
                    context.nextToken();
                    postTextResponseBuilder.responseCard(ResponseCardUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return postTextResponseBuilder.build();
    }

    private static final PostTextResponseUnmarshaller INSTANCE = new PostTextResponseUnmarshaller();

    public static PostTextResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
