/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntime.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.lexruntime.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * PostContentResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PostContentResponseUnmarshaller implements Unmarshaller<PostContentResponse, JsonUnmarshallerContext> {

    public PostContentResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        PostContentResponse.Builder postContentResponseBuilder = PostContentResponse.builder();

        if (context.isStartOfDocument()) {
            if (context.getHeader("Content-Type") != null) {
                context.setCurrentHeader("Content-Type");
                postContentResponseBuilder.contentType(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("x-amz-lex-intent-name") != null) {
                context.setCurrentHeader("x-amz-lex-intent-name");
                postContentResponseBuilder.intentName(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("x-amz-lex-slots") != null) {
                context.setCurrentHeader("x-amz-lex-slots");
                postContentResponseBuilder.slots(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("x-amz-lex-session-attributes") != null) {
                context.setCurrentHeader("x-amz-lex-session-attributes");
                postContentResponseBuilder.sessionAttributes(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("x-amz-lex-message") != null) {
                context.setCurrentHeader("x-amz-lex-message");
                postContentResponseBuilder.message(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("x-amz-lex-message-format") != null) {
                context.setCurrentHeader("x-amz-lex-message-format");
                postContentResponseBuilder.messageFormat(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("x-amz-lex-dialog-state") != null) {
                context.setCurrentHeader("x-amz-lex-dialog-state");
                postContentResponseBuilder.dialogState(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("x-amz-lex-slot-to-elicit") != null) {
                context.setCurrentHeader("x-amz-lex-slot-to-elicit");
                postContentResponseBuilder.slotToElicit(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("x-amz-lex-input-transcript") != null) {
                context.setCurrentHeader("x-amz-lex-input-transcript");
                postContentResponseBuilder.inputTranscript(context.getUnmarshaller(String.class).unmarshall(context));
            }
        }

        return postContentResponseBuilder.build();
    }

    private static final PostContentResponseUnmarshaller INSTANCE = new PostContentResponseUnmarshaller();

    public static PostContentResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
