/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntime.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexruntime.model.PostContentRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link PostContentRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class PostContentRequestModelMarshaller {
    private static final MarshallingInfo<String> BOTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("botName").isBinary(false).build();

    private static final MarshallingInfo<String> BOTALIAS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("botAlias").isBinary(false).build();

    private static final MarshallingInfo<String> USERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("userId").isBinary(false).build();

    private static final MarshallingInfo<String> SESSIONATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-lex-session-attributes").isBinary(false)
            .build();

    private static final MarshallingInfo<String> REQUESTATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-lex-request-attributes").isBinary(false)
            .build();

    private static final MarshallingInfo<String> CONTENTTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.HEADER).marshallLocationName("Content-Type").isBinary(false).build();

    private static final MarshallingInfo<String> ACCEPT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.HEADER).marshallLocationName("Accept").isBinary(false).build();

    private static final PostContentRequestModelMarshaller INSTANCE = new PostContentRequestModelMarshaller();

    private PostContentRequestModelMarshaller() {
    }

    public static PostContentRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(PostContentRequest postContentRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(postContentRequest, "postContentRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(postContentRequest.botName(), BOTNAME_BINDING);
            protocolMarshaller.marshall(postContentRequest.botAlias(), BOTALIAS_BINDING);
            protocolMarshaller.marshall(postContentRequest.userId(), USERID_BINDING);
            protocolMarshaller.marshall(postContentRequest.sessionAttributes(), SESSIONATTRIBUTES_BINDING);
            protocolMarshaller.marshall(postContentRequest.requestAttributes(), REQUESTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(postContentRequest.contentType(), CONTENTTYPE_BINDING);
            protocolMarshaller.marshall(postContentRequest.accept(), ACCEPT_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
