/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntime.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexruntime.model.GenericAttachment;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link GenericAttachment} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class GenericAttachmentMarshaller {
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("title").isBinary(false).build();

    private static final MarshallingInfo<String> SUBTITLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subTitle").isBinary(false).build();

    private static final MarshallingInfo<String> ATTACHMENTLINKURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attachmentLinkUrl").isBinary(false).build();

    private static final MarshallingInfo<String> IMAGEURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageUrl").isBinary(false).build();

    private static final MarshallingInfo<List> BUTTONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("buttons").isBinary(false).build();

    private static final GenericAttachmentMarshaller INSTANCE = new GenericAttachmentMarshaller();

    private GenericAttachmentMarshaller() {
    }

    public static GenericAttachmentMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(GenericAttachment genericAttachment, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(genericAttachment, "genericAttachment");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(genericAttachment.title(), TITLE_BINDING);
            protocolMarshaller.marshall(genericAttachment.subTitle(), SUBTITLE_BINDING);
            protocolMarshaller.marshall(genericAttachment.attachmentLinkUrl(), ATTACHMENTLINKURL_BINDING);
            protocolMarshaller.marshall(genericAttachment.imageUrl(), IMAGEURL_BINDING);
            protocolMarshaller.marshall(genericAttachment.buttons(), BUTTONS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
