/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntime.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexruntime.transform.ButtonMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an option to be shown on the client platform (Facebook, Slack, etc.)
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Button implements StructuredPojo, ToCopyableBuilder<Button.Builder, Button> {
    private final String text;

    private final String value;

    private Button(BuilderImpl builder) {
        this.text = builder.text;
        this.value = builder.value;
    }

    /**
     * <p>
     * Text that is visible to the user on the button.
     * </p>
     * 
     * @return Text that is visible to the user on the button.
     */
    public String text() {
        return text;
    }

    /**
     * <p>
     * The value sent to Amazon Lex when a user chooses the button. For example, consider button text "NYC." When the
     * user chooses the button, the value sent can be "New York City."
     * </p>
     * 
     * @return The value sent to Amazon Lex when a user chooses the button. For example, consider button text "NYC."
     *         When the user chooses the button, the value sent can be "New York City."
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Button)) {
            return false;
        }
        Button other = (Button) obj;
        return Objects.equals(text(), other.text()) && Objects.equals(value(), other.value());
    }

    @Override
    public String toString() {
        return ToString.builder("Button").add("Text", text()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ButtonMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Button> {
        /**
         * <p>
         * Text that is visible to the user on the button.
         * </p>
         * 
         * @param text
         *        Text that is visible to the user on the button.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The value sent to Amazon Lex when a user chooses the button. For example, consider button text "NYC." When
         * the user chooses the button, the value sent can be "New York City."
         * </p>
         * 
         * @param value
         *        The value sent to Amazon Lex when a user chooses the button. For example, consider button text "NYC."
         *        When the user chooses the button, the value sent can be "New York City."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String text;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Button model) {
            text(model.text);
            value(model.value);
        }

        public final String getText() {
            return text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public Button build() {
            return new Button(this);
        }
    }
}
