/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kms.model.AliasListEntry;

@SdkInternalApi
public class AliasListEntryMarshaller {
    private static final MarshallingInfo<String> ALIASNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AliasName").build();
    private static final MarshallingInfo<String> ALIASARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AliasArn").build();
    private static final MarshallingInfo<String> TARGETKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetKeyId").build();
    private static final AliasListEntryMarshaller instance = new AliasListEntryMarshaller();

    public static AliasListEntryMarshaller getInstance() {
        return instance;
    }

    public void marshall(AliasListEntry aliasListEntry, ProtocolMarshaller protocolMarshaller) {
        if (aliasListEntry == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)aliasListEntry.aliasName(), ALIASNAME_BINDING);
            protocolMarshaller.marshall((Object)aliasListEntry.aliasArn(), ALIASARN_BINDING);
            protocolMarshaller.marshall((Object)aliasListEntry.targetKeyId(), TARGETKEYID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

