/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideosignaling;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesisvideosignaling.DefaultKinesisVideoSignalingBaseClientBuilder;
import software.amazon.awssdk.services.kinesisvideosignaling.DefaultKinesisVideoSignalingClient;
import software.amazon.awssdk.services.kinesisvideosignaling.KinesisVideoSignalingClient;
import software.amazon.awssdk.services.kinesisvideosignaling.KinesisVideoSignalingClientBuilder;
import software.amazon.awssdk.services.kinesisvideosignaling.KinesisVideoSignalingServiceClientConfiguration;
import software.amazon.awssdk.services.kinesisvideosignaling.endpoints.KinesisVideoSignalingEndpointProvider;

@SdkInternalApi
final class DefaultKinesisVideoSignalingClientBuilder
extends DefaultKinesisVideoSignalingBaseClientBuilder<KinesisVideoSignalingClientBuilder, KinesisVideoSignalingClient>
implements KinesisVideoSignalingClientBuilder {
    DefaultKinesisVideoSignalingClientBuilder() {
    }

    @Override
    public DefaultKinesisVideoSignalingClientBuilder endpointProvider(KinesisVideoSignalingEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final KinesisVideoSignalingClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultKinesisVideoSignalingClientBuilder.validateClientOptions(clientConfiguration);
        KinesisVideoSignalingServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultKinesisVideoSignalingClient client = new DefaultKinesisVideoSignalingClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private KinesisVideoSignalingServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return KinesisVideoSignalingServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

