/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideosignaling.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure for the ICE server connection data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IceServer implements SdkPojo, Serializable, ToCopyableBuilder<IceServer.Builder, IceServer> {
    private static final SdkField<List<String>> URIS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Uris")
            .getter(getter(IceServer::uris))
            .setter(setter(Builder::uris))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uris").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(IceServer::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(IceServer::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<Integer> TTL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Ttl")
            .getter(getter(IceServer::ttl)).setter(setter(Builder::ttl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ttl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URIS_FIELD, USERNAME_FIELD,
            PASSWORD_FIELD, TTL_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> uris;

    private final String username;

    private final String password;

    private final Integer ttl;

    private IceServer(BuilderImpl builder) {
        this.uris = builder.uris;
        this.username = builder.username;
        this.password = builder.password;
        this.ttl = builder.ttl;
    }

    /**
     * For responses, this returns true if the service returned a value for the Uris property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUris() {
        return uris != null && !(uris instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of URIs, in the form specified in the <a
     * href="https://tools.ietf.org/html/draft-petithuguenin-behave-turn-uris-03">I-D.petithuguenin-behave-turn-uris</a>
     * spec. These URIs provide the different addresses and/or protocols that can be used to reach the TURN server.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUris} method.
     * </p>
     * 
     * @return An array of URIs, in the form specified in the <a
     *         href="https://tools.ietf.org/html/draft-petithuguenin-behave-turn-uris-03"
     *         >I-D.petithuguenin-behave-turn-uris</a> spec. These URIs provide the different addresses and/or protocols
     *         that can be used to reach the TURN server.
     */
    public final List<String> uris() {
        return uris;
    }

    /**
     * <p>
     * A username to login to the ICE server.
     * </p>
     * 
     * @return A username to login to the ICE server.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * A password to login to the ICE server.
     * </p>
     * 
     * @return A password to login to the ICE server.
     */
    public final String password() {
        return password;
    }

    /**
     * <p>
     * The period of time, in seconds, during which the username and password are valid.
     * </p>
     * 
     * @return The period of time, in seconds, during which the username and password are valid.
     */
    public final Integer ttl() {
        return ttl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasUris() ? uris() : null);
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(ttl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IceServer)) {
            return false;
        }
        IceServer other = (IceServer) obj;
        return hasUris() == other.hasUris() && Objects.equals(uris(), other.uris())
                && Objects.equals(username(), other.username()) && Objects.equals(password(), other.password())
                && Objects.equals(ttl(), other.ttl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IceServer").add("Uris", hasUris() ? uris() : null).add("Username", username())
                .add("Password", password()).add("Ttl", ttl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Uris":
            return Optional.ofNullable(clazz.cast(uris()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "Ttl":
            return Optional.ofNullable(clazz.cast(ttl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IceServer, T> g) {
        return obj -> g.apply((IceServer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IceServer> {
        /**
         * <p>
         * An array of URIs, in the form specified in the <a
         * href="https://tools.ietf.org/html/draft-petithuguenin-behave-turn-uris-03"
         * >I-D.petithuguenin-behave-turn-uris</a> spec. These URIs provide the different addresses and/or protocols
         * that can be used to reach the TURN server.
         * </p>
         * 
         * @param uris
         *        An array of URIs, in the form specified in the <a
         *        href="https://tools.ietf.org/html/draft-petithuguenin-behave-turn-uris-03"
         *        >I-D.petithuguenin-behave-turn-uris</a> spec. These URIs provide the different addresses and/or
         *        protocols that can be used to reach the TURN server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uris(Collection<String> uris);

        /**
         * <p>
         * An array of URIs, in the form specified in the <a
         * href="https://tools.ietf.org/html/draft-petithuguenin-behave-turn-uris-03"
         * >I-D.petithuguenin-behave-turn-uris</a> spec. These URIs provide the different addresses and/or protocols
         * that can be used to reach the TURN server.
         * </p>
         * 
         * @param uris
         *        An array of URIs, in the form specified in the <a
         *        href="https://tools.ietf.org/html/draft-petithuguenin-behave-turn-uris-03"
         *        >I-D.petithuguenin-behave-turn-uris</a> spec. These URIs provide the different addresses and/or
         *        protocols that can be used to reach the TURN server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uris(String... uris);

        /**
         * <p>
         * A username to login to the ICE server.
         * </p>
         * 
         * @param username
         *        A username to login to the ICE server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * A password to login to the ICE server.
         * </p>
         * 
         * @param password
         *        A password to login to the ICE server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * The period of time, in seconds, during which the username and password are valid.
         * </p>
         * 
         * @param ttl
         *        The period of time, in seconds, during which the username and password are valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(Integer ttl);
    }

    static final class BuilderImpl implements Builder {
        private List<String> uris = DefaultSdkAutoConstructList.getInstance();

        private String username;

        private String password;

        private Integer ttl;

        private BuilderImpl() {
        }

        private BuilderImpl(IceServer model) {
            uris(model.uris);
            username(model.username);
            password(model.password);
            ttl(model.ttl);
        }

        public final Collection<String> getUris() {
            if (uris instanceof SdkAutoConstructList) {
                return null;
            }
            return uris;
        }

        public final void setUris(Collection<String> uris) {
            this.uris = UrisCopier.copy(uris);
        }

        @Override
        @Transient
        public final Builder uris(Collection<String> uris) {
            this.uris = UrisCopier.copy(uris);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder uris(String... uris) {
            uris(Arrays.asList(uris));
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        @Transient
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        @Transient
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final Integer getTtl() {
            return ttl;
        }

        public final void setTtl(Integer ttl) {
            this.ttl = ttl;
        }

        @Override
        @Transient
        public final Builder ttl(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        @Override
        public IceServer build() {
            return new IceServer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
