/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionUpdatesCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.InputUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.InputUpdatesCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.OutputUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.OutputUpdatesCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceUpdatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationUpdate> {
    private static final SdkField<List<InputUpdate>> INPUT_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputUpdates").getter(ApplicationUpdate.getter(ApplicationUpdate::inputUpdates)).setter(ApplicationUpdate.setter(Builder::inputUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APPLICATION_CODE_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationCodeUpdate").getter(ApplicationUpdate.getter(ApplicationUpdate::applicationCodeUpdate)).setter(ApplicationUpdate.setter(Builder::applicationCodeUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationCodeUpdate").build()}).build();
    private static final SdkField<List<OutputUpdate>> OUTPUT_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OutputUpdates").getter(ApplicationUpdate.getter(ApplicationUpdate::outputUpdates)).setter(ApplicationUpdate.setter(Builder::outputUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ReferenceDataSourceUpdate>> REFERENCE_DATA_SOURCE_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReferenceDataSourceUpdates").getter(ApplicationUpdate.getter(ApplicationUpdate::referenceDataSourceUpdates)).setter(ApplicationUpdate.setter(Builder::referenceDataSourceUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceDataSourceUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReferenceDataSourceUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CloudWatchLoggingOptionUpdate>> CLOUD_WATCH_LOGGING_OPTION_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CloudWatchLoggingOptionUpdates").getter(ApplicationUpdate.getter(ApplicationUpdate::cloudWatchLoggingOptionUpdates)).setter(ApplicationUpdate.setter(Builder::cloudWatchLoggingOptionUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptionUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CloudWatchLoggingOptionUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_UPDATES_FIELD, APPLICATION_CODE_UPDATE_FIELD, OUTPUT_UPDATES_FIELD, REFERENCE_DATA_SOURCE_UPDATES_FIELD, CLOUD_WATCH_LOGGING_OPTION_UPDATES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<InputUpdate> inputUpdates;
    private final String applicationCodeUpdate;
    private final List<OutputUpdate> outputUpdates;
    private final List<ReferenceDataSourceUpdate> referenceDataSourceUpdates;
    private final List<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates;

    private ApplicationUpdate(BuilderImpl builder) {
        this.inputUpdates = builder.inputUpdates;
        this.applicationCodeUpdate = builder.applicationCodeUpdate;
        this.outputUpdates = builder.outputUpdates;
        this.referenceDataSourceUpdates = builder.referenceDataSourceUpdates;
        this.cloudWatchLoggingOptionUpdates = builder.cloudWatchLoggingOptionUpdates;
    }

    public final boolean hasInputUpdates() {
        return this.inputUpdates != null && !(this.inputUpdates instanceof SdkAutoConstructList);
    }

    public final List<InputUpdate> inputUpdates() {
        return this.inputUpdates;
    }

    public final String applicationCodeUpdate() {
        return this.applicationCodeUpdate;
    }

    public final boolean hasOutputUpdates() {
        return this.outputUpdates != null && !(this.outputUpdates instanceof SdkAutoConstructList);
    }

    public final List<OutputUpdate> outputUpdates() {
        return this.outputUpdates;
    }

    public final boolean hasReferenceDataSourceUpdates() {
        return this.referenceDataSourceUpdates != null && !(this.referenceDataSourceUpdates instanceof SdkAutoConstructList);
    }

    public final List<ReferenceDataSourceUpdate> referenceDataSourceUpdates() {
        return this.referenceDataSourceUpdates;
    }

    public final boolean hasCloudWatchLoggingOptionUpdates() {
        return this.cloudWatchLoggingOptionUpdates != null && !(this.cloudWatchLoggingOptionUpdates instanceof SdkAutoConstructList);
    }

    public final List<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates() {
        return this.cloudWatchLoggingOptionUpdates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputUpdates() ? this.inputUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationCodeUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputUpdates() ? this.outputUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferenceDataSourceUpdates() ? this.referenceDataSourceUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCloudWatchLoggingOptionUpdates() ? this.cloudWatchLoggingOptionUpdates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationUpdate)) {
            return false;
        }
        ApplicationUpdate other = (ApplicationUpdate)obj;
        return this.hasInputUpdates() == other.hasInputUpdates() && Objects.equals(this.inputUpdates(), other.inputUpdates()) && Objects.equals(this.applicationCodeUpdate(), other.applicationCodeUpdate()) && this.hasOutputUpdates() == other.hasOutputUpdates() && Objects.equals(this.outputUpdates(), other.outputUpdates()) && this.hasReferenceDataSourceUpdates() == other.hasReferenceDataSourceUpdates() && Objects.equals(this.referenceDataSourceUpdates(), other.referenceDataSourceUpdates()) && this.hasCloudWatchLoggingOptionUpdates() == other.hasCloudWatchLoggingOptionUpdates() && Objects.equals(this.cloudWatchLoggingOptionUpdates(), other.cloudWatchLoggingOptionUpdates());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationUpdate").add("InputUpdates", this.hasInputUpdates() ? this.inputUpdates() : null).add("ApplicationCodeUpdate", (Object)this.applicationCodeUpdate()).add("OutputUpdates", this.hasOutputUpdates() ? this.outputUpdates() : null).add("ReferenceDataSourceUpdates", this.hasReferenceDataSourceUpdates() ? this.referenceDataSourceUpdates() : null).add("CloudWatchLoggingOptionUpdates", this.hasCloudWatchLoggingOptionUpdates() ? this.cloudWatchLoggingOptionUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputUpdates": {
                return Optional.ofNullable(clazz.cast(this.inputUpdates()));
            }
            case "ApplicationCodeUpdate": {
                return Optional.ofNullable(clazz.cast(this.applicationCodeUpdate()));
            }
            case "OutputUpdates": {
                return Optional.ofNullable(clazz.cast(this.outputUpdates()));
            }
            case "ReferenceDataSourceUpdates": {
                return Optional.ofNullable(clazz.cast(this.referenceDataSourceUpdates()));
            }
            case "CloudWatchLoggingOptionUpdates": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptionUpdates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationUpdate, T> g) {
        return obj -> g.apply((ApplicationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<InputUpdate> inputUpdates = DefaultSdkAutoConstructList.getInstance();
        private String applicationCodeUpdate;
        private List<OutputUpdate> outputUpdates = DefaultSdkAutoConstructList.getInstance();
        private List<ReferenceDataSourceUpdate> referenceDataSourceUpdates = DefaultSdkAutoConstructList.getInstance();
        private List<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationUpdate model) {
            this.inputUpdates(model.inputUpdates);
            this.applicationCodeUpdate(model.applicationCodeUpdate);
            this.outputUpdates(model.outputUpdates);
            this.referenceDataSourceUpdates(model.referenceDataSourceUpdates);
            this.cloudWatchLoggingOptionUpdates(model.cloudWatchLoggingOptionUpdates);
        }

        public final Collection<InputUpdate.Builder> getInputUpdates() {
            if (this.inputUpdates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputUpdates != null ? (Collection)this.inputUpdates.stream().map(InputUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputUpdates(Collection<InputUpdate> inputUpdates) {
            this.inputUpdates = InputUpdatesCopier.copy(inputUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputUpdates(InputUpdate ... inputUpdates) {
            this.inputUpdates(Arrays.asList(inputUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputUpdates(Consumer<InputUpdate.Builder> ... inputUpdates) {
            this.inputUpdates(Stream.of(inputUpdates).map(c -> (InputUpdate)((InputUpdate.Builder)InputUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputUpdates(Collection<InputUpdate.BuilderImpl> inputUpdates) {
            this.inputUpdates = InputUpdatesCopier.copyFromBuilder(inputUpdates);
        }

        public final String getApplicationCodeUpdate() {
            return this.applicationCodeUpdate;
        }

        @Override
        public final Builder applicationCodeUpdate(String applicationCodeUpdate) {
            this.applicationCodeUpdate = applicationCodeUpdate;
            return this;
        }

        public final void setApplicationCodeUpdate(String applicationCodeUpdate) {
            this.applicationCodeUpdate = applicationCodeUpdate;
        }

        public final Collection<OutputUpdate.Builder> getOutputUpdates() {
            if (this.outputUpdates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.outputUpdates != null ? (Collection)this.outputUpdates.stream().map(OutputUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputUpdates(Collection<OutputUpdate> outputUpdates) {
            this.outputUpdates = OutputUpdatesCopier.copy(outputUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputUpdates(OutputUpdate ... outputUpdates) {
            this.outputUpdates(Arrays.asList(outputUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputUpdates(Consumer<OutputUpdate.Builder> ... outputUpdates) {
            this.outputUpdates(Stream.of(outputUpdates).map(c -> (OutputUpdate)((OutputUpdate.Builder)OutputUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputUpdates(Collection<OutputUpdate.BuilderImpl> outputUpdates) {
            this.outputUpdates = OutputUpdatesCopier.copyFromBuilder(outputUpdates);
        }

        public final Collection<ReferenceDataSourceUpdate.Builder> getReferenceDataSourceUpdates() {
            if (this.referenceDataSourceUpdates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.referenceDataSourceUpdates != null ? (Collection)this.referenceDataSourceUpdates.stream().map(ReferenceDataSourceUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder referenceDataSourceUpdates(Collection<ReferenceDataSourceUpdate> referenceDataSourceUpdates) {
            this.referenceDataSourceUpdates = ReferenceDataSourceUpdatesCopier.copy(referenceDataSourceUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSourceUpdates(ReferenceDataSourceUpdate ... referenceDataSourceUpdates) {
            this.referenceDataSourceUpdates(Arrays.asList(referenceDataSourceUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSourceUpdates(Consumer<ReferenceDataSourceUpdate.Builder> ... referenceDataSourceUpdates) {
            this.referenceDataSourceUpdates(Stream.of(referenceDataSourceUpdates).map(c -> (ReferenceDataSourceUpdate)((ReferenceDataSourceUpdate.Builder)ReferenceDataSourceUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReferenceDataSourceUpdates(Collection<ReferenceDataSourceUpdate.BuilderImpl> referenceDataSourceUpdates) {
            this.referenceDataSourceUpdates = ReferenceDataSourceUpdatesCopier.copyFromBuilder(referenceDataSourceUpdates);
        }

        public final Collection<CloudWatchLoggingOptionUpdate.Builder> getCloudWatchLoggingOptionUpdates() {
            if (this.cloudWatchLoggingOptionUpdates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cloudWatchLoggingOptionUpdates != null ? (Collection)this.cloudWatchLoggingOptionUpdates.stream().map(CloudWatchLoggingOptionUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptionUpdates(Collection<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates) {
            this.cloudWatchLoggingOptionUpdates = CloudWatchLoggingOptionUpdatesCopier.copy(cloudWatchLoggingOptionUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionUpdates(CloudWatchLoggingOptionUpdate ... cloudWatchLoggingOptionUpdates) {
            this.cloudWatchLoggingOptionUpdates(Arrays.asList(cloudWatchLoggingOptionUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionUpdates(Consumer<CloudWatchLoggingOptionUpdate.Builder> ... cloudWatchLoggingOptionUpdates) {
            this.cloudWatchLoggingOptionUpdates(Stream.of(cloudWatchLoggingOptionUpdates).map(c -> (CloudWatchLoggingOptionUpdate)((CloudWatchLoggingOptionUpdate.Builder)CloudWatchLoggingOptionUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCloudWatchLoggingOptionUpdates(Collection<CloudWatchLoggingOptionUpdate.BuilderImpl> cloudWatchLoggingOptionUpdates) {
            this.cloudWatchLoggingOptionUpdates = CloudWatchLoggingOptionUpdatesCopier.copyFromBuilder(cloudWatchLoggingOptionUpdates);
        }

        public ApplicationUpdate build() {
            return new ApplicationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationUpdate> {
        public Builder inputUpdates(Collection<InputUpdate> var1);

        public Builder inputUpdates(InputUpdate ... var1);

        public Builder inputUpdates(Consumer<InputUpdate.Builder> ... var1);

        public Builder applicationCodeUpdate(String var1);

        public Builder outputUpdates(Collection<OutputUpdate> var1);

        public Builder outputUpdates(OutputUpdate ... var1);

        public Builder outputUpdates(Consumer<OutputUpdate.Builder> ... var1);

        public Builder referenceDataSourceUpdates(Collection<ReferenceDataSourceUpdate> var1);

        public Builder referenceDataSourceUpdates(ReferenceDataSourceUpdate ... var1);

        public Builder referenceDataSourceUpdates(Consumer<ReferenceDataSourceUpdate.Builder> ... var1);

        public Builder cloudWatchLoggingOptionUpdates(Collection<CloudWatchLoggingOptionUpdate> var1);

        public Builder cloudWatchLoggingOptionUpdates(CloudWatchLoggingOptionUpdate ... var1);

        public Builder cloudWatchLoggingOptionUpdates(Consumer<CloudWatchLoggingOptionUpdate.Builder> ... var1);
    }
}

