/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.endpoints;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class KinesisEndpointParams
implements ToCopyableBuilder<Builder, KinesisEndpointParams> {
    private final Region region;
    private final Boolean useDualStack;
    private final Boolean useFIPS;
    private final String endpoint;
    private final String streamARN;
    private final String operationType;
    private final String consumerARN;
    private final String resourceARN;

    private KinesisEndpointParams(BuilderImpl builder) {
        this.region = builder.region;
        this.useDualStack = builder.useDualStack;
        this.useFIPS = builder.useFIPS;
        this.endpoint = builder.endpoint;
        this.streamARN = builder.streamARN;
        this.operationType = builder.operationType;
        this.consumerARN = builder.consumerARN;
        this.resourceARN = builder.resourceARN;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Region region() {
        return this.region;
    }

    public Boolean useDualStack() {
        return this.useDualStack;
    }

    public Boolean useFips() {
        return this.useFIPS;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String streamArn() {
        return this.streamARN;
    }

    public String operationType() {
        return this.operationType;
    }

    public String consumerArn() {
        return this.consumerARN;
    }

    public String resourceArn() {
        return this.resourceARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    private static class BuilderImpl
    implements Builder {
        private Region region;
        private Boolean useDualStack = false;
        private Boolean useFIPS = false;
        private String endpoint;
        private String streamARN;
        private String operationType;
        private String consumerARN;
        private String resourceARN;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisEndpointParams builder) {
            this.region = builder.region;
            this.useDualStack = builder.useDualStack;
            this.useFIPS = builder.useFIPS;
            this.endpoint = builder.endpoint;
            this.streamARN = builder.streamARN;
            this.operationType = builder.operationType;
            this.consumerARN = builder.consumerARN;
            this.resourceARN = builder.resourceARN;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder useDualStack(Boolean useDualStack) {
            this.useDualStack = useDualStack;
            if (this.useDualStack == null) {
                this.useDualStack = false;
            }
            return this;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public Builder streamArn(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        @Override
        public Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public Builder consumerArn(String consumerARN) {
            this.consumerARN = consumerARN;
            return this;
        }

        @Override
        public Builder resourceArn(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        @Override
        public KinesisEndpointParams build() {
            return new KinesisEndpointParams(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KinesisEndpointParams> {
        public Builder region(Region var1);

        public Builder useDualStack(Boolean var1);

        public Builder useFips(Boolean var1);

        public Builder endpoint(String var1);

        public Builder streamArn(String var1);

        public Builder operationType(String var1);

        public Builder consumerArn(String var1);

        public Builder resourceArn(String var1);

        public KinesisEndpointParams build();
    }
}

