/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the details of the consumer you registered. This type of object is returned by
 * <a>RegisterStreamConsumer</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Consumer implements SdkPojo, Serializable, ToCopyableBuilder<Consumer.Builder, Consumer> {
    private static final SdkField<String> CONSUMER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsumerName").getter(getter(Consumer::consumerName)).setter(setter(Builder::consumerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerName").build()).build();

    private static final SdkField<String> CONSUMER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsumerARN").getter(getter(Consumer::consumerARN)).setter(setter(Builder::consumerARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerARN").build()).build();

    private static final SdkField<String> CONSUMER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsumerStatus").getter(getter(Consumer::consumerStatusAsString))
            .setter(setter(Builder::consumerStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerStatus").build()).build();

    private static final SdkField<Instant> CONSUMER_CREATION_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("ConsumerCreationTimestamp")
            .getter(getter(Consumer::consumerCreationTimestamp)).setter(setter(Builder::consumerCreationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerCreationTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMER_NAME_FIELD,
            CONSUMER_ARN_FIELD, CONSUMER_STATUS_FIELD, CONSUMER_CREATION_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String consumerName;

    private final String consumerARN;

    private final String consumerStatus;

    private final Instant consumerCreationTimestamp;

    private Consumer(BuilderImpl builder) {
        this.consumerName = builder.consumerName;
        this.consumerARN = builder.consumerARN;
        this.consumerStatus = builder.consumerStatus;
        this.consumerCreationTimestamp = builder.consumerCreationTimestamp;
    }

    /**
     * <p>
     * The name of the consumer is something you choose when you register the consumer.
     * </p>
     * 
     * @return The name of the consumer is something you choose when you register the consumer.
     */
    public final String consumerName() {
        return consumerName;
    }

    /**
     * <p>
     * When you register a consumer, Kinesis Data Streams generates an ARN for it. You need this ARN to be able to call
     * <a>SubscribeToShard</a>.
     * </p>
     * <p>
     * If you delete a consumer and then create a new one with the same name, it won't have the same ARN. That's because
     * consumer ARNs contain the creation timestamp. This is important to keep in mind if you have IAM policies that
     * reference consumer ARNs.
     * </p>
     * 
     * @return When you register a consumer, Kinesis Data Streams generates an ARN for it. You need this ARN to be able
     *         to call <a>SubscribeToShard</a>.</p>
     *         <p>
     *         If you delete a consumer and then create a new one with the same name, it won't have the same ARN. That's
     *         because consumer ARNs contain the creation timestamp. This is important to keep in mind if you have IAM
     *         policies that reference consumer ARNs.
     */
    public final String consumerARN() {
        return consumerARN;
    }

    /**
     * <p>
     * A consumer can't read data while in the <code>CREATING</code> or <code>DELETING</code> states.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #consumerStatus}
     * will return {@link ConsumerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #consumerStatusAsString}.
     * </p>
     * 
     * @return A consumer can't read data while in the <code>CREATING</code> or <code>DELETING</code> states.
     * @see ConsumerStatus
     */
    public final ConsumerStatus consumerStatus() {
        return ConsumerStatus.fromValue(consumerStatus);
    }

    /**
     * <p>
     * A consumer can't read data while in the <code>CREATING</code> or <code>DELETING</code> states.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #consumerStatus}
     * will return {@link ConsumerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #consumerStatusAsString}.
     * </p>
     * 
     * @return A consumer can't read data while in the <code>CREATING</code> or <code>DELETING</code> states.
     * @see ConsumerStatus
     */
    public final String consumerStatusAsString() {
        return consumerStatus;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Instant consumerCreationTimestamp() {
        return consumerCreationTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(consumerName());
        hashCode = 31 * hashCode + Objects.hashCode(consumerARN());
        hashCode = 31 * hashCode + Objects.hashCode(consumerStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(consumerCreationTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Consumer)) {
            return false;
        }
        Consumer other = (Consumer) obj;
        return Objects.equals(consumerName(), other.consumerName()) && Objects.equals(consumerARN(), other.consumerARN())
                && Objects.equals(consumerStatusAsString(), other.consumerStatusAsString())
                && Objects.equals(consumerCreationTimestamp(), other.consumerCreationTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Consumer").add("ConsumerName", consumerName()).add("ConsumerARN", consumerARN())
                .add("ConsumerStatus", consumerStatusAsString()).add("ConsumerCreationTimestamp", consumerCreationTimestamp())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConsumerName":
            return Optional.ofNullable(clazz.cast(consumerName()));
        case "ConsumerARN":
            return Optional.ofNullable(clazz.cast(consumerARN()));
        case "ConsumerStatus":
            return Optional.ofNullable(clazz.cast(consumerStatusAsString()));
        case "ConsumerCreationTimestamp":
            return Optional.ofNullable(clazz.cast(consumerCreationTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConsumerName", CONSUMER_NAME_FIELD);
        map.put("ConsumerARN", CONSUMER_ARN_FIELD);
        map.put("ConsumerStatus", CONSUMER_STATUS_FIELD);
        map.put("ConsumerCreationTimestamp", CONSUMER_CREATION_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Consumer, T> g) {
        return obj -> g.apply((Consumer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Consumer> {
        /**
         * <p>
         * The name of the consumer is something you choose when you register the consumer.
         * </p>
         * 
         * @param consumerName
         *        The name of the consumer is something you choose when you register the consumer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerName(String consumerName);

        /**
         * <p>
         * When you register a consumer, Kinesis Data Streams generates an ARN for it. You need this ARN to be able to
         * call <a>SubscribeToShard</a>.
         * </p>
         * <p>
         * If you delete a consumer and then create a new one with the same name, it won't have the same ARN. That's
         * because consumer ARNs contain the creation timestamp. This is important to keep in mind if you have IAM
         * policies that reference consumer ARNs.
         * </p>
         * 
         * @param consumerARN
         *        When you register a consumer, Kinesis Data Streams generates an ARN for it. You need this ARN to be
         *        able to call <a>SubscribeToShard</a>.</p>
         *        <p>
         *        If you delete a consumer and then create a new one with the same name, it won't have the same ARN.
         *        That's because consumer ARNs contain the creation timestamp. This is important to keep in mind if you
         *        have IAM policies that reference consumer ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerARN(String consumerARN);

        /**
         * <p>
         * A consumer can't read data while in the <code>CREATING</code> or <code>DELETING</code> states.
         * </p>
         * 
         * @param consumerStatus
         *        A consumer can't read data while in the <code>CREATING</code> or <code>DELETING</code> states.
         * @see ConsumerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConsumerStatus
         */
        Builder consumerStatus(String consumerStatus);

        /**
         * <p>
         * A consumer can't read data while in the <code>CREATING</code> or <code>DELETING</code> states.
         * </p>
         * 
         * @param consumerStatus
         *        A consumer can't read data while in the <code>CREATING</code> or <code>DELETING</code> states.
         * @see ConsumerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConsumerStatus
         */
        Builder consumerStatus(ConsumerStatus consumerStatus);

        /**
         * <p/>
         * 
         * @param consumerCreationTimestamp
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerCreationTimestamp(Instant consumerCreationTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String consumerName;

        private String consumerARN;

        private String consumerStatus;

        private Instant consumerCreationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Consumer model) {
            consumerName(model.consumerName);
            consumerARN(model.consumerARN);
            consumerStatus(model.consumerStatus);
            consumerCreationTimestamp(model.consumerCreationTimestamp);
        }

        public final String getConsumerName() {
            return consumerName;
        }

        public final void setConsumerName(String consumerName) {
            this.consumerName = consumerName;
        }

        @Override
        public final Builder consumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        public final String getConsumerARN() {
            return consumerARN;
        }

        public final void setConsumerARN(String consumerARN) {
            this.consumerARN = consumerARN;
        }

        @Override
        public final Builder consumerARN(String consumerARN) {
            this.consumerARN = consumerARN;
            return this;
        }

        public final String getConsumerStatus() {
            return consumerStatus;
        }

        public final void setConsumerStatus(String consumerStatus) {
            this.consumerStatus = consumerStatus;
        }

        @Override
        public final Builder consumerStatus(String consumerStatus) {
            this.consumerStatus = consumerStatus;
            return this;
        }

        @Override
        public final Builder consumerStatus(ConsumerStatus consumerStatus) {
            this.consumerStatus(consumerStatus == null ? null : consumerStatus.toString());
            return this;
        }

        public final Instant getConsumerCreationTimestamp() {
            return consumerCreationTimestamp;
        }

        public final void setConsumerCreationTimestamp(Instant consumerCreationTimestamp) {
            this.consumerCreationTimestamp = consumerCreationTimestamp;
        }

        @Override
        public final Builder consumerCreationTimestamp(Instant consumerCreationTimestamp) {
            this.consumerCreationTimestamp = consumerCreationTimestamp;
            return this;
        }

        @Override
        public Consumer build() {
            return new Consumer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
