/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTagsForStreamRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, ListTagsForStreamRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(ListTagsForStreamRequest.getter(ListTagsForStreamRequest::streamName)).setter(ListTagsForStreamRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<String> EXCLUSIVE_START_TAG_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExclusiveStartTagKey").getter(ListTagsForStreamRequest.getter(ListTagsForStreamRequest::exclusiveStartTagKey)).setter(ListTagsForStreamRequest.setter(Builder::exclusiveStartTagKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartTagKey").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(ListTagsForStreamRequest.getter(ListTagsForStreamRequest::limit)).setter(ListTagsForStreamRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(ListTagsForStreamRequest.getter(ListTagsForStreamRequest::streamARN)).setter(ListTagsForStreamRequest.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, EXCLUSIVE_START_TAG_KEY_FIELD, LIMIT_FIELD, STREAM_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTagsForStreamRequest.memberNameToFieldInitializer();
    private final String streamName;
    private final String exclusiveStartTagKey;
    private final Integer limit;
    private final String streamARN;

    private ListTagsForStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.exclusiveStartTagKey = builder.exclusiveStartTagKey;
        this.limit = builder.limit;
        this.streamARN = builder.streamARN;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final String exclusiveStartTagKey() {
        return this.exclusiveStartTagKey;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String streamARN() {
        return this.streamARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartTagKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForStreamRequest)) {
            return false;
        }
        ListTagsForStreamRequest other = (ListTagsForStreamRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.exclusiveStartTagKey(), other.exclusiveStartTagKey()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.streamARN(), other.streamARN());
    }

    public final String toString() {
        return ToString.builder((String)"ListTagsForStreamRequest").add("StreamName", (Object)this.streamName()).add("ExclusiveStartTagKey", (Object)this.exclusiveStartTagKey()).add("Limit", (Object)this.limit()).add("StreamARN", (Object)this.streamARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "ExclusiveStartTagKey": {
                return Optional.ofNullable(clazz.cast(this.exclusiveStartTagKey()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("ExclusiveStartTagKey", EXCLUSIVE_START_TAG_KEY_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("StreamARN", STREAM_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTagsForStreamRequest, T> g) {
        return obj -> g.apply((ListTagsForStreamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private String exclusiveStartTagKey;
        private Integer limit;
        private String streamARN;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForStreamRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.exclusiveStartTagKey(model.exclusiveStartTagKey);
            this.limit(model.limit);
            this.streamARN(model.streamARN);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getExclusiveStartTagKey() {
            return this.exclusiveStartTagKey;
        }

        public final void setExclusiveStartTagKey(String exclusiveStartTagKey) {
            this.exclusiveStartTagKey = exclusiveStartTagKey;
        }

        @Override
        public final Builder exclusiveStartTagKey(String exclusiveStartTagKey) {
            this.exclusiveStartTagKey = exclusiveStartTagKey;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTagsForStreamRequest build() {
            return new ListTagsForStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTagsForStreamRequest> {
        public Builder streamName(String var1);

        public Builder exclusiveStartTagKey(String var1);

        public Builder limit(Integer var1);

        public Builder streamARN(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

