/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.RecordColumn;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RecordColumnMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> MAPPING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Mapping").isBinary(false).build();
    private static final MarshallingInfo<String> SQLTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SqlType").isBinary(false).build();
    private static final RecordColumnMarshaller INSTANCE = new RecordColumnMarshaller();

    private RecordColumnMarshaller() {
    }

    public static RecordColumnMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RecordColumn recordColumn, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)recordColumn, (String)"recordColumn");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)recordColumn.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)recordColumn.mapping(), MAPPING_BINDING);
            protocolMarshaller.marshall((Object)recordColumn.sqlType(), SQLTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

