/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseOutputUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class KinesisFirehoseOutputUpdateMarshaller {
    private static final MarshallingInfo<String> RESOURCEARNUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceARNUpdate").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARNUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARNUpdate").isBinary(false).build();
    private static final KinesisFirehoseOutputUpdateMarshaller INSTANCE = new KinesisFirehoseOutputUpdateMarshaller();

    private KinesisFirehoseOutputUpdateMarshaller() {
    }

    public static KinesisFirehoseOutputUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KinesisFirehoseOutputUpdate kinesisFirehoseOutputUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)kinesisFirehoseOutputUpdate, (String)"kinesisFirehoseOutputUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)kinesisFirehoseOutputUpdate.resourceARNUpdate(), RESOURCEARNUPDATE_BINDING);
            protocolMarshaller.marshall((Object)kinesisFirehoseOutputUpdate.roleARNUpdate(), ROLEARNUPDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

