/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.InputUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InputUpdateMarshaller {
    private static final MarshallingInfo<String> INPUTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputId").isBinary(false).build();
    private static final MarshallingInfo<String> NAMEPREFIXUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NamePrefixUpdate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INPUTPROCESSINGCONFIGURATIONUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputProcessingConfigurationUpdate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSINPUTUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamsInputUpdate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> KINESISFIREHOSEINPUTUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisFirehoseInputUpdate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INPUTSCHEMAUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputSchemaUpdate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INPUTPARALLELISMUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputParallelismUpdate").isBinary(false).build();
    private static final InputUpdateMarshaller INSTANCE = new InputUpdateMarshaller();

    private InputUpdateMarshaller() {
    }

    public static InputUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InputUpdate inputUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)inputUpdate, (String)"inputUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)inputUpdate.inputId(), INPUTID_BINDING);
            protocolMarshaller.marshall((Object)inputUpdate.namePrefixUpdate(), NAMEPREFIXUPDATE_BINDING);
            protocolMarshaller.marshall((Object)inputUpdate.inputProcessingConfigurationUpdate(), INPUTPROCESSINGCONFIGURATIONUPDATE_BINDING);
            protocolMarshaller.marshall((Object)inputUpdate.kinesisStreamsInputUpdate(), KINESISSTREAMSINPUTUPDATE_BINDING);
            protocolMarshaller.marshall((Object)inputUpdate.kinesisFirehoseInputUpdate(), KINESISFIREHOSEINPUTUPDATE_BINDING);
            protocolMarshaller.marshall((Object)inputUpdate.inputSchemaUpdate(), INPUTSCHEMAUPDATE_BINDING);
            protocolMarshaller.marshall((Object)inputUpdate.inputParallelismUpdate(), INPUTPARALLELISMUPDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

