/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InputProcessingConfigurationMarshaller {
    private static final MarshallingInfo<StructuredPojo> INPUTLAMBDAPROCESSOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputLambdaProcessor").isBinary(false).build();
    private static final InputProcessingConfigurationMarshaller INSTANCE = new InputProcessingConfigurationMarshaller();

    private InputProcessingConfigurationMarshaller() {
    }

    public static InputProcessingConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InputProcessingConfiguration inputProcessingConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)inputProcessingConfiguration, (String)"inputProcessingConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)inputProcessingConfiguration.inputLambdaProcessor(), INPUTLAMBDAPROCESSOR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

