/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetShardIteratorRequestModelMarshaller {
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamName").isBinary(false).build();
    private static final MarshallingInfo<String> SHARDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShardId").isBinary(false).build();
    private static final MarshallingInfo<String> SHARDITERATORTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShardIteratorType").isBinary(false).build();
    private static final MarshallingInfo<String> STARTINGSEQUENCENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartingSequenceNumber").isBinary(false).build();
    private static final MarshallingInfo<Instant> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").isBinary(false).build();
    private static final GetShardIteratorRequestModelMarshaller INSTANCE = new GetShardIteratorRequestModelMarshaller();

    private GetShardIteratorRequestModelMarshaller() {
    }

    public static GetShardIteratorRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetShardIteratorRequest getShardIteratorRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getShardIteratorRequest), (String)"getShardIteratorRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getShardIteratorRequest.streamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)getShardIteratorRequest.shardId(), SHARDID_BINDING);
            protocolMarshaller.marshall((Object)getShardIteratorRequest.shardIteratorTypeString(), SHARDITERATORTYPE_BINDING);
            protocolMarshaller.marshall((Object)getShardIteratorRequest.startingSequenceNumber(), STARTINGSEQUENCENUMBER_BINDING);
            protocolMarshaller.marshall((Object)getShardIteratorRequest.timestamp(), TIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

