/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntry;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PutRecordBatchResponseEntryMarshaller {
    private static final MarshallingInfo<String> RECORDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordId").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCode").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").isBinary(false).build();
    private static final PutRecordBatchResponseEntryMarshaller INSTANCE = new PutRecordBatchResponseEntryMarshaller();

    private PutRecordBatchResponseEntryMarshaller() {
    }

    public static PutRecordBatchResponseEntryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PutRecordBatchResponseEntry putRecordBatchResponseEntry, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)putRecordBatchResponseEntry, (String)"putRecordBatchResponseEntry");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)putRecordBatchResponseEntry.recordId(), RECORDID_BINDING);
            protocolMarshaller.marshall((Object)putRecordBatchResponseEntry.errorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)putRecordBatchResponseEntry.errorMessage(), ERRORMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

