/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.Input;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Input} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class InputMarshaller {
    private static final MarshallingInfo<String> NAMEPREFIX_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NamePrefix").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> INPUTPROCESSINGCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("InputProcessingConfiguration").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSINPUT_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("KinesisStreamsInput").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> KINESISFIREHOSEINPUT_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("KinesisFirehoseInput").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> INPUTPARALLELISM_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("InputParallelism").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> INPUTSCHEMA_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputSchema")
            .isBinary(false).build();

    private static final InputMarshaller INSTANCE = new InputMarshaller();

    private InputMarshaller() {
    }

    public static InputMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Input input, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(input, "input");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(input.namePrefix(), NAMEPREFIX_BINDING);
            protocolMarshaller.marshall(input.inputProcessingConfiguration(), INPUTPROCESSINGCONFIGURATION_BINDING);
            protocolMarshaller.marshall(input.kinesisStreamsInput(), KINESISSTREAMSINPUT_BINDING);
            protocolMarshaller.marshall(input.kinesisFirehoseInput(), KINESISFIREHOSEINPUT_BINDING);
            protocolMarshaller.marshall(input.inputParallelism(), INPUTPARALLELISM_BINDING);
            protocolMarshaller.marshall(input.inputSchema(), INPUTSCHEMA_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
