/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.transform;

import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.InputDescription;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link InputDescription} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class InputDescriptionMarshaller {
    private static final MarshallingInfo<String> INPUTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputId").isBinary(false).build();

    private static final MarshallingInfo<String> NAMEPREFIX_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NamePrefix").isBinary(false).build();

    private static final MarshallingInfo<List> INAPPSTREAMNAMES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InAppStreamNames").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> INPUTPROCESSINGCONFIGURATIONDESCRIPTION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("InputProcessingConfigurationDescription").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSINPUTDESCRIPTION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("KinesisStreamsInputDescription").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> KINESISFIREHOSEINPUTDESCRIPTION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("KinesisFirehoseInputDescription").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> INPUTSCHEMA_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputSchema")
            .isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> INPUTPARALLELISM_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("InputParallelism").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> INPUTSTARTINGPOSITIONCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("InputStartingPositionConfiguration").isBinary(false).build();

    private static final InputDescriptionMarshaller INSTANCE = new InputDescriptionMarshaller();

    private InputDescriptionMarshaller() {
    }

    public static InputDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(InputDescription inputDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(inputDescription, "inputDescription");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(inputDescription.inputId(), INPUTID_BINDING);
            protocolMarshaller.marshall(inputDescription.namePrefix(), NAMEPREFIX_BINDING);
            protocolMarshaller.marshall(inputDescription.inAppStreamNames(), INAPPSTREAMNAMES_BINDING);
            protocolMarshaller.marshall(inputDescription.inputProcessingConfigurationDescription(),
                    INPUTPROCESSINGCONFIGURATIONDESCRIPTION_BINDING);
            protocolMarshaller
                    .marshall(inputDescription.kinesisStreamsInputDescription(), KINESISSTREAMSINPUTDESCRIPTION_BINDING);
            protocolMarshaller.marshall(inputDescription.kinesisFirehoseInputDescription(),
                    KINESISFIREHOSEINPUTDESCRIPTION_BINDING);
            protocolMarshaller.marshall(inputDescription.inputSchema(), INPUTSCHEMA_BINDING);
            protocolMarshaller.marshall(inputDescription.inputParallelism(), INPUTPARALLELISM_BINDING);
            protocolMarshaller.marshall(inputDescription.inputStartingPositionConfiguration(),
                    INPUTSTARTINGPOSITIONCONFIGURATION_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
