/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputLambdaProcessorUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an update to the <a>InputLambdaProcessor</a> that is used to preprocess the records in the stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InputLambdaProcessorUpdate implements StructuredPojo,
        ToCopyableBuilder<InputLambdaProcessorUpdate.Builder, InputLambdaProcessorUpdate> {
    private final String resourceARNUpdate;

    private final String roleARNUpdate;

    private InputLambdaProcessorUpdate(BuilderImpl builder) {
        this.resourceARNUpdate = builder.resourceARNUpdate;
        this.roleARNUpdate = builder.roleARNUpdate;
    }

    /**
     * <p>
     * The ARN of the new <a href="https://aws.amazon.com/documentation/lambda/">AWS Lambda</a> function that is used to
     * preprocess the records in the stream.
     * </p>
     * 
     * @return The ARN of the new <a href="https://aws.amazon.com/documentation/lambda/">AWS Lambda</a> function that is
     *         used to preprocess the records in the stream.
     */
    public String resourceARNUpdate() {
        return resourceARNUpdate;
    }

    /**
     * <p>
     * The ARN of the new IAM role used to access the AWS Lambda function.
     * </p>
     * 
     * @return The ARN of the new IAM role used to access the AWS Lambda function.
     */
    public String roleARNUpdate() {
        return roleARNUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceARNUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(roleARNUpdate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputLambdaProcessorUpdate)) {
            return false;
        }
        InputLambdaProcessorUpdate other = (InputLambdaProcessorUpdate) obj;
        return Objects.equals(resourceARNUpdate(), other.resourceARNUpdate())
                && Objects.equals(roleARNUpdate(), other.roleARNUpdate());
    }

    @Override
    public String toString() {
        return ToString.builder("InputLambdaProcessorUpdate").add("ResourceARNUpdate", resourceARNUpdate())
                .add("RoleARNUpdate", roleARNUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceARNUpdate":
            return Optional.of(clazz.cast(resourceARNUpdate()));
        case "RoleARNUpdate":
            return Optional.of(clazz.cast(roleARNUpdate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputLambdaProcessorUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InputLambdaProcessorUpdate> {
        /**
         * <p>
         * The ARN of the new <a href="https://aws.amazon.com/documentation/lambda/">AWS Lambda</a> function that is
         * used to preprocess the records in the stream.
         * </p>
         * 
         * @param resourceARNUpdate
         *        The ARN of the new <a href="https://aws.amazon.com/documentation/lambda/">AWS Lambda</a> function that
         *        is used to preprocess the records in the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARNUpdate(String resourceARNUpdate);

        /**
         * <p>
         * The ARN of the new IAM role used to access the AWS Lambda function.
         * </p>
         * 
         * @param roleARNUpdate
         *        The ARN of the new IAM role used to access the AWS Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARNUpdate(String roleARNUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String resourceARNUpdate;

        private String roleARNUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(InputLambdaProcessorUpdate model) {
            resourceARNUpdate(model.resourceARNUpdate);
            roleARNUpdate(model.roleARNUpdate);
        }

        public final String getResourceARNUpdate() {
            return resourceARNUpdate;
        }

        @Override
        public final Builder resourceARNUpdate(String resourceARNUpdate) {
            this.resourceARNUpdate = resourceARNUpdate;
            return this;
        }

        public final void setResourceARNUpdate(String resourceARNUpdate) {
            this.resourceARNUpdate = resourceARNUpdate;
        }

        public final String getRoleARNUpdate() {
            return roleARNUpdate;
        }

        @Override
        public final Builder roleARNUpdate(String roleARNUpdate) {
            this.roleARNUpdate = roleARNUpdate;
            return this;
        }

        public final void setRoleARNUpdate(String roleARNUpdate) {
            this.roleARNUpdate = roleARNUpdate;
        }

        @Override
        public InputLambdaProcessorUpdate build() {
            return new InputLambdaProcessorUpdate(this);
        }
    }
}
