/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DiscoverInputSchemaResponse extends KinesisAnalyticsResponse implements
        ToCopyableBuilder<DiscoverInputSchemaResponse.Builder, DiscoverInputSchemaResponse> {
    private final SourceSchema inputSchema;

    private final List<List<String>> parsedInputRecords;

    private final List<String> processedInputRecords;

    private final List<String> rawInputRecords;

    private DiscoverInputSchemaResponse(BuilderImpl builder) {
        super(builder);
        this.inputSchema = builder.inputSchema;
        this.parsedInputRecords = builder.parsedInputRecords;
        this.processedInputRecords = builder.processedInputRecords;
        this.rawInputRecords = builder.rawInputRecords;
    }

    /**
     * <p>
     * Schema inferred from the streaming source. It identifies the format of the data in the streaming source and how
     * each data element maps to corresponding columns in the in-application stream that you can create.
     * </p>
     * 
     * @return Schema inferred from the streaming source. It identifies the format of the data in the streaming source
     *         and how each data element maps to corresponding columns in the in-application stream that you can create.
     */
    public SourceSchema inputSchema() {
        return inputSchema;
    }

    /**
     * <p>
     * An array of elements, where each element corresponds to a row in a stream record (a stream record can have more
     * than one row).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of elements, where each element corresponds to a row in a stream record (a stream record can
     *         have more than one row).
     */
    public List<List<String>> parsedInputRecords() {
        return parsedInputRecords;
    }

    /**
     * <p>
     * Stream data that was modified by the processor specified in the <code>InputProcessingConfiguration</code>
     * parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Stream data that was modified by the processor specified in the <code>InputProcessingConfiguration</code>
     *         parameter.
     */
    public List<String> processedInputRecords() {
        return processedInputRecords;
    }

    /**
     * <p>
     * Raw stream data that was sampled to infer the schema.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Raw stream data that was sampled to infer the schema.
     */
    public List<String> rawInputRecords() {
        return rawInputRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputSchema());
        hashCode = 31 * hashCode + Objects.hashCode(parsedInputRecords());
        hashCode = 31 * hashCode + Objects.hashCode(processedInputRecords());
        hashCode = 31 * hashCode + Objects.hashCode(rawInputRecords());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverInputSchemaResponse)) {
            return false;
        }
        DiscoverInputSchemaResponse other = (DiscoverInputSchemaResponse) obj;
        return Objects.equals(inputSchema(), other.inputSchema())
                && Objects.equals(parsedInputRecords(), other.parsedInputRecords())
                && Objects.equals(processedInputRecords(), other.processedInputRecords())
                && Objects.equals(rawInputRecords(), other.rawInputRecords());
    }

    @Override
    public String toString() {
        return ToString.builder("DiscoverInputSchemaResponse").add("InputSchema", inputSchema())
                .add("ParsedInputRecords", parsedInputRecords()).add("ProcessedInputRecords", processedInputRecords())
                .add("RawInputRecords", rawInputRecords()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputSchema":
            return Optional.of(clazz.cast(inputSchema()));
        case "ParsedInputRecords":
            return Optional.of(clazz.cast(parsedInputRecords()));
        case "ProcessedInputRecords":
            return Optional.of(clazz.cast(processedInputRecords()));
        case "RawInputRecords":
            return Optional.of(clazz.cast(rawInputRecords()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisAnalyticsResponse.Builder, CopyableBuilder<Builder, DiscoverInputSchemaResponse> {
        /**
         * <p>
         * Schema inferred from the streaming source. It identifies the format of the data in the streaming source and
         * how each data element maps to corresponding columns in the in-application stream that you can create.
         * </p>
         * 
         * @param inputSchema
         *        Schema inferred from the streaming source. It identifies the format of the data in the streaming
         *        source and how each data element maps to corresponding columns in the in-application stream that you
         *        can create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSchema(SourceSchema inputSchema);

        /**
         * <p>
         * Schema inferred from the streaming source. It identifies the format of the data in the streaming source and
         * how each data element maps to corresponding columns in the in-application stream that you can create.
         * </p>
         * This is a convenience that creates an instance of the {@link SourceSchema.Builder} avoiding the need to
         * create one manually via {@link SourceSchema#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #inputSchema(SourceSchema)}.
         * 
         * @param inputSchema
         *        a consumer that will call methods on {@link SourceSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputSchema(SourceSchema)
         */
        default Builder inputSchema(Consumer<SourceSchema.Builder> inputSchema) {
            return inputSchema(SourceSchema.builder().apply(inputSchema).build());
        }

        /**
         * <p>
         * An array of elements, where each element corresponds to a row in a stream record (a stream record can have
         * more than one row).
         * </p>
         * 
         * @param parsedInputRecords
         *        An array of elements, where each element corresponds to a row in a stream record (a stream record can
         *        have more than one row).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parsedInputRecords(Collection<? extends Collection<String>> parsedInputRecords);

        /**
         * <p>
         * An array of elements, where each element corresponds to a row in a stream record (a stream record can have
         * more than one row).
         * </p>
         * 
         * @param parsedInputRecords
         *        An array of elements, where each element corresponds to a row in a stream record (a stream record can
         *        have more than one row).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parsedInputRecords(Collection<String>... parsedInputRecords);

        /**
         * <p>
         * Stream data that was modified by the processor specified in the <code>InputProcessingConfiguration</code>
         * parameter.
         * </p>
         * 
         * @param processedInputRecords
         *        Stream data that was modified by the processor specified in the
         *        <code>InputProcessingConfiguration</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedInputRecords(Collection<String> processedInputRecords);

        /**
         * <p>
         * Stream data that was modified by the processor specified in the <code>InputProcessingConfiguration</code>
         * parameter.
         * </p>
         * 
         * @param processedInputRecords
         *        Stream data that was modified by the processor specified in the
         *        <code>InputProcessingConfiguration</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedInputRecords(String... processedInputRecords);

        /**
         * <p>
         * Raw stream data that was sampled to infer the schema.
         * </p>
         * 
         * @param rawInputRecords
         *        Raw stream data that was sampled to infer the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawInputRecords(Collection<String> rawInputRecords);

        /**
         * <p>
         * Raw stream data that was sampled to infer the schema.
         * </p>
         * 
         * @param rawInputRecords
         *        Raw stream data that was sampled to infer the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawInputRecords(String... rawInputRecords);
    }

    static final class BuilderImpl extends KinesisAnalyticsResponse.BuilderImpl implements Builder {
        private SourceSchema inputSchema;

        private List<List<String>> parsedInputRecords;

        private List<String> processedInputRecords;

        private List<String> rawInputRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoverInputSchemaResponse model) {
            inputSchema(model.inputSchema);
            parsedInputRecords(model.parsedInputRecords);
            processedInputRecords(model.processedInputRecords);
            rawInputRecords(model.rawInputRecords);
        }

        public final SourceSchema.Builder getInputSchema() {
            return inputSchema != null ? inputSchema.toBuilder() : null;
        }

        @Override
        public final Builder inputSchema(SourceSchema inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public final void setInputSchema(SourceSchema.BuilderImpl inputSchema) {
            this.inputSchema = inputSchema != null ? inputSchema.build() : null;
        }

        public final Collection<? extends Collection<String>> getParsedInputRecords() {
            return parsedInputRecords;
        }

        @Override
        public final Builder parsedInputRecords(Collection<? extends Collection<String>> parsedInputRecords) {
            this.parsedInputRecords = ParsedInputRecordsCopier.copy(parsedInputRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parsedInputRecords(Collection<String>... parsedInputRecords) {
            parsedInputRecords(Arrays.asList(parsedInputRecords));
            return this;
        }

        public final void setParsedInputRecords(Collection<? extends Collection<String>> parsedInputRecords) {
            this.parsedInputRecords = ParsedInputRecordsCopier.copy(parsedInputRecords);
        }

        public final Collection<String> getProcessedInputRecords() {
            return processedInputRecords;
        }

        @Override
        public final Builder processedInputRecords(Collection<String> processedInputRecords) {
            this.processedInputRecords = ProcessedInputRecordsCopier.copy(processedInputRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedInputRecords(String... processedInputRecords) {
            processedInputRecords(Arrays.asList(processedInputRecords));
            return this;
        }

        public final void setProcessedInputRecords(Collection<String> processedInputRecords) {
            this.processedInputRecords = ProcessedInputRecordsCopier.copy(processedInputRecords);
        }

        public final Collection<String> getRawInputRecords() {
            return rawInputRecords;
        }

        @Override
        public final Builder rawInputRecords(Collection<String> rawInputRecords) {
            this.rawInputRecords = RawInputRecordsCopier.copy(rawInputRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rawInputRecords(String... rawInputRecords) {
            rawInputRecords(Arrays.asList(rawInputRecords));
            return this;
        }

        public final void setRawInputRecords(Collection<String> rawInputRecords) {
            this.rawInputRecords = RawInputRecordsCopier.copy(rawInputRecords);
        }

        @Override
        public DiscoverInputSchemaResponse build() {
            return new DiscoverInputSchemaResponse(this);
        }
    }
}
