/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for <code>ListTagsForStream</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTagsForStreamRequest extends KinesisRequest implements
        ToCopyableBuilder<ListTagsForStreamRequest.Builder, ListTagsForStreamRequest> {
    private final String streamName;

    private final String exclusiveStartTagKey;

    private final Integer limit;

    private ListTagsForStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.exclusiveStartTagKey = builder.exclusiveStartTagKey;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The name of the stream.
     * </p>
     * 
     * @return The name of the stream.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The key to use as the starting point for the list of tags. If this parameter is set,
     * <code>ListTagsForStream</code> gets all tags that occur after <code>ExclusiveStartTagKey</code>.
     * </p>
     * 
     * @return The key to use as the starting point for the list of tags. If this parameter is set,
     *         <code>ListTagsForStream</code> gets all tags that occur after <code>ExclusiveStartTagKey</code>.
     */
    public String exclusiveStartTagKey() {
        return exclusiveStartTagKey;
    }

    /**
     * <p>
     * The number of tags to return. If this number is less than the total number of tags associated with the stream,
     * <code>HasMoreTags</code> is set to <code>true</code>. To list additional tags, set
     * <code>ExclusiveStartTagKey</code> to the last key in the response.
     * </p>
     * 
     * @return The number of tags to return. If this number is less than the total number of tags associated with the
     *         stream, <code>HasMoreTags</code> is set to <code>true</code>. To list additional tags, set
     *         <code>ExclusiveStartTagKey</code> to the last key in the response.
     */
    public Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveStartTagKey());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForStreamRequest)) {
            return false;
        }
        ListTagsForStreamRequest other = (ListTagsForStreamRequest) obj;
        return Objects.equals(streamName(), other.streamName())
                && Objects.equals(exclusiveStartTagKey(), other.exclusiveStartTagKey()) && Objects.equals(limit(), other.limit());
    }

    @Override
    public String toString() {
        return ToString.builder("ListTagsForStreamRequest").add("StreamName", streamName())
                .add("ExclusiveStartTagKey", exclusiveStartTagKey()).add("Limit", limit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.of(clazz.cast(streamName()));
        case "ExclusiveStartTagKey":
            return Optional.of(clazz.cast(exclusiveStartTagKey()));
        case "Limit":
            return Optional.of(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisRequest.Builder, CopyableBuilder<Builder, ListTagsForStreamRequest> {
        /**
         * <p>
         * The name of the stream.
         * </p>
         * 
         * @param streamName
         *        The name of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The key to use as the starting point for the list of tags. If this parameter is set,
         * <code>ListTagsForStream</code> gets all tags that occur after <code>ExclusiveStartTagKey</code>.
         * </p>
         * 
         * @param exclusiveStartTagKey
         *        The key to use as the starting point for the list of tags. If this parameter is set,
         *        <code>ListTagsForStream</code> gets all tags that occur after <code>ExclusiveStartTagKey</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartTagKey(String exclusiveStartTagKey);

        /**
         * <p>
         * The number of tags to return. If this number is less than the total number of tags associated with the
         * stream, <code>HasMoreTags</code> is set to <code>true</code>. To list additional tags, set
         * <code>ExclusiveStartTagKey</code> to the last key in the response.
         * </p>
         * 
         * @param limit
         *        The number of tags to return. If this number is less than the total number of tags associated with the
         *        stream, <code>HasMoreTags</code> is set to <code>true</code>. To list additional tags, set
         *        <code>ExclusiveStartTagKey</code> to the last key in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends KinesisRequest.BuilderImpl implements Builder {
        private String streamName;

        private String exclusiveStartTagKey;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForStreamRequest model) {
            streamName(model.streamName);
            exclusiveStartTagKey(model.exclusiveStartTagKey);
            limit(model.limit);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getExclusiveStartTagKey() {
            return exclusiveStartTagKey;
        }

        @Override
        public final Builder exclusiveStartTagKey(String exclusiveStartTagKey) {
            this.exclusiveStartTagKey = exclusiveStartTagKey;
            return this;
        }

        public final void setExclusiveStartTagKey(String exclusiveStartTagKey) {
            this.exclusiveStartTagKey = exclusiveStartTagKey;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListTagsForStreamRequest build() {
            return new ListTagsForStreamRequest(this);
        }
    }
}
