/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output for <code>GetShardIterator</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetShardIteratorResponse extends KinesisResponse implements
        ToCopyableBuilder<GetShardIteratorResponse.Builder, GetShardIteratorResponse> {
    private final String shardIterator;

    private GetShardIteratorResponse(BuilderImpl builder) {
        super(builder);
        this.shardIterator = builder.shardIterator;
    }

    /**
     * <p>
     * The position in the shard from which to start reading data records sequentially. A shard iterator specifies this
     * position using the sequence number of a data record in a shard.
     * </p>
     * 
     * @return The position in the shard from which to start reading data records sequentially. A shard iterator
     *         specifies this position using the sequence number of a data record in a shard.
     */
    public String shardIterator() {
        return shardIterator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(shardIterator());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetShardIteratorResponse)) {
            return false;
        }
        GetShardIteratorResponse other = (GetShardIteratorResponse) obj;
        return Objects.equals(shardIterator(), other.shardIterator());
    }

    @Override
    public String toString() {
        return ToString.builder("GetShardIteratorResponse").add("ShardIterator", shardIterator()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShardIterator":
            return Optional.of(clazz.cast(shardIterator()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisResponse.Builder, CopyableBuilder<Builder, GetShardIteratorResponse> {
        /**
         * <p>
         * The position in the shard from which to start reading data records sequentially. A shard iterator specifies
         * this position using the sequence number of a data record in a shard.
         * </p>
         * 
         * @param shardIterator
         *        The position in the shard from which to start reading data records sequentially. A shard iterator
         *        specifies this position using the sequence number of a data record in a shard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardIterator(String shardIterator);
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private String shardIterator;

        private BuilderImpl() {
        }

        private BuilderImpl(GetShardIteratorResponse model) {
            shardIterator(model.shardIterator);
        }

        public final String getShardIterator() {
            return shardIterator;
        }

        @Override
        public final Builder shardIterator(String shardIterator) {
            this.shardIterator = shardIterator;
            return this;
        }

        public final void setShardIterator(String shardIterator) {
            this.shardIterator = shardIterator;
        }

        @Override
        public GetShardIteratorResponse build() {
            return new GetShardIteratorResponse(this);
        }
    }
}
