/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output for <a>EnableEnhancedMonitoring</a> and <a>DisableEnhancedMonitoring</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class EnableEnhancedMonitoringResponse extends KinesisResponse implements
        ToCopyableBuilder<EnableEnhancedMonitoringResponse.Builder, EnableEnhancedMonitoringResponse> {
    private final String streamName;

    private final List<String> currentShardLevelMetrics;

    private final List<String> desiredShardLevelMetrics;

    private EnableEnhancedMonitoringResponse(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.currentShardLevelMetrics = builder.currentShardLevelMetrics;
        this.desiredShardLevelMetrics = builder.desiredShardLevelMetrics;
    }

    /**
     * <p>
     * The name of the Kinesis stream.
     * </p>
     * 
     * @return The name of the Kinesis stream.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * Represents the current state of the metrics that are in the enhanced state before the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents the current state of the metrics that are in the enhanced state before the operation.
     */
    public List<MetricsName> currentShardLevelMetrics() {
        return TypeConverter.convert(currentShardLevelMetrics, MetricsName::fromValue);
    }

    /**
     * <p>
     * Represents the current state of the metrics that are in the enhanced state before the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents the current state of the metrics that are in the enhanced state before the operation.
     */
    public List<String> currentShardLevelMetricsStrings() {
        return currentShardLevelMetrics;
    }

    /**
     * <p>
     * Represents the list of all the metrics that would be in the enhanced state after the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents the list of all the metrics that would be in the enhanced state after the operation.
     */
    public List<MetricsName> desiredShardLevelMetrics() {
        return TypeConverter.convert(desiredShardLevelMetrics, MetricsName::fromValue);
    }

    /**
     * <p>
     * Represents the list of all the metrics that would be in the enhanced state after the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents the list of all the metrics that would be in the enhanced state after the operation.
     */
    public List<String> desiredShardLevelMetricsStrings() {
        return desiredShardLevelMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(currentShardLevelMetricsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(desiredShardLevelMetricsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableEnhancedMonitoringResponse)) {
            return false;
        }
        EnableEnhancedMonitoringResponse other = (EnableEnhancedMonitoringResponse) obj;
        return Objects.equals(streamName(), other.streamName())
                && Objects.equals(currentShardLevelMetricsStrings(), other.currentShardLevelMetricsStrings())
                && Objects.equals(desiredShardLevelMetricsStrings(), other.desiredShardLevelMetricsStrings());
    }

    @Override
    public String toString() {
        return ToString.builder("EnableEnhancedMonitoringResponse").add("StreamName", streamName())
                .add("CurrentShardLevelMetrics", currentShardLevelMetricsStrings())
                .add("DesiredShardLevelMetrics", desiredShardLevelMetricsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.of(clazz.cast(streamName()));
        case "CurrentShardLevelMetrics":
            return Optional.of(clazz.cast(currentShardLevelMetricsStrings()));
        case "DesiredShardLevelMetrics":
            return Optional.of(clazz.cast(desiredShardLevelMetricsStrings()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisResponse.Builder, CopyableBuilder<Builder, EnableEnhancedMonitoringResponse> {
        /**
         * <p>
         * The name of the Kinesis stream.
         * </p>
         * 
         * @param streamName
         *        The name of the Kinesis stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * Represents the current state of the metrics that are in the enhanced state before the operation.
         * </p>
         * 
         * @param currentShardLevelMetrics
         *        Represents the current state of the metrics that are in the enhanced state before the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentShardLevelMetrics(Collection<String> currentShardLevelMetrics);

        /**
         * <p>
         * Represents the current state of the metrics that are in the enhanced state before the operation.
         * </p>
         * 
         * @param currentShardLevelMetrics
         *        Represents the current state of the metrics that are in the enhanced state before the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentShardLevelMetrics(String... currentShardLevelMetrics);

        /**
         * <p>
         * Represents the list of all the metrics that would be in the enhanced state after the operation.
         * </p>
         * 
         * @param desiredShardLevelMetrics
         *        Represents the list of all the metrics that would be in the enhanced state after the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredShardLevelMetrics(Collection<String> desiredShardLevelMetrics);

        /**
         * <p>
         * Represents the list of all the metrics that would be in the enhanced state after the operation.
         * </p>
         * 
         * @param desiredShardLevelMetrics
         *        Represents the list of all the metrics that would be in the enhanced state after the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredShardLevelMetrics(String... desiredShardLevelMetrics);
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private String streamName;

        private List<String> currentShardLevelMetrics;

        private List<String> desiredShardLevelMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableEnhancedMonitoringResponse model) {
            streamName(model.streamName);
            currentShardLevelMetrics(model.currentShardLevelMetrics);
            desiredShardLevelMetrics(model.desiredShardLevelMetrics);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Collection<String> getCurrentShardLevelMetrics() {
            return currentShardLevelMetrics;
        }

        @Override
        public final Builder currentShardLevelMetrics(Collection<String> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copy(currentShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentShardLevelMetrics(String... currentShardLevelMetrics) {
            currentShardLevelMetrics(Arrays.asList(currentShardLevelMetrics));
            return this;
        }

        public final void setCurrentShardLevelMetrics(Collection<String> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copy(currentShardLevelMetrics);
        }

        public final Collection<String> getDesiredShardLevelMetrics() {
            return desiredShardLevelMetrics;
        }

        @Override
        public final Builder desiredShardLevelMetrics(Collection<String> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copy(desiredShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredShardLevelMetrics(String... desiredShardLevelMetrics) {
            desiredShardLevelMetrics(Arrays.asList(desiredShardLevelMetrics));
            return this;
        }

        public final void setDesiredShardLevelMetrics(Collection<String> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copy(desiredShardLevelMetrics);
        }

        @Override
        public EnableEnhancedMonitoringResponse build() {
            return new EnableEnhancedMonitoringResponse(this);
        }
    }
}
