/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.RedshiftDestinationUpdate;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link RedshiftDestinationUpdate} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class RedshiftDestinationUpdateMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();

    private static final MarshallingInfo<String> CLUSTERJDBCURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterJDBCURL").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> COPYCOMMAND_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CopyCommand")
            .isBinary(false).build();

    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").isBinary(false).build();

    private static final MarshallingInfo<String> PASSWORD_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Password").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> RETRYOPTIONS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetryOptions")
            .isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> S3UPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Update").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> PROCESSINGCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ProcessingConfiguration").isBinary(false).build();

    private static final MarshallingInfo<String> S3BACKUPMODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BackupMode").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> S3BACKUPUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("S3BackupUpdate").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHLOGGINGOPTIONS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("CloudWatchLoggingOptions").isBinary(false).build();

    private static final RedshiftDestinationUpdateMarshaller INSTANCE = new RedshiftDestinationUpdateMarshaller();

    private RedshiftDestinationUpdateMarshaller() {
    }

    public static RedshiftDestinationUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(RedshiftDestinationUpdate redshiftDestinationUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(redshiftDestinationUpdate, "redshiftDestinationUpdate");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(redshiftDestinationUpdate.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall(redshiftDestinationUpdate.clusterJDBCURL(), CLUSTERJDBCURL_BINDING);
            protocolMarshaller.marshall(redshiftDestinationUpdate.copyCommand(), COPYCOMMAND_BINDING);
            protocolMarshaller.marshall(redshiftDestinationUpdate.username(), USERNAME_BINDING);
            protocolMarshaller.marshall(redshiftDestinationUpdate.password(), PASSWORD_BINDING);
            protocolMarshaller.marshall(redshiftDestinationUpdate.retryOptions(), RETRYOPTIONS_BINDING);
            protocolMarshaller.marshall(redshiftDestinationUpdate.s3Update(), S3UPDATE_BINDING);
            protocolMarshaller.marshall(redshiftDestinationUpdate.processingConfiguration(), PROCESSINGCONFIGURATION_BINDING);
            protocolMarshaller.marshall(redshiftDestinationUpdate.s3BackupModeString(), S3BACKUPMODE_BINDING);
            protocolMarshaller.marshall(redshiftDestinationUpdate.s3BackupUpdate(), S3BACKUPUPDATE_BINDING);
            protocolMarshaller.marshall(redshiftDestinationUpdate.cloudWatchLoggingOptions(), CLOUDWATCHLOGGINGOPTIONS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
