/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ListDeliveryStreamsRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ListDeliveryStreamsRequestModelMarshaller {
    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Limit").isBinary(false).build();

    private static final MarshallingInfo<String> DELIVERYSTREAMTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamType").isBinary(false).build();

    private static final MarshallingInfo<String> EXCLUSIVESTARTDELIVERYSTREAMNAME_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ExclusiveStartDeliveryStreamName").isBinary(false).build();

    private static final ListDeliveryStreamsRequestModelMarshaller INSTANCE = new ListDeliveryStreamsRequestModelMarshaller();

    private ListDeliveryStreamsRequestModelMarshaller() {
    }

    public static ListDeliveryStreamsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ListDeliveryStreamsRequest listDeliveryStreamsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(listDeliveryStreamsRequest, "listDeliveryStreamsRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(listDeliveryStreamsRequest.limit(), LIMIT_BINDING);
            protocolMarshaller.marshall(listDeliveryStreamsRequest.deliveryStreamTypeString(), DELIVERYSTREAMTYPE_BINDING);
            protocolMarshaller.marshall(listDeliveryStreamsRequest.exclusiveStartDeliveryStreamName(),
                    EXCLUSIVESTARTDELIVERYSTREAMNAME_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
