/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateDestinationRequest extends FirehoseRequest implements
        ToCopyableBuilder<UpdateDestinationRequest.Builder, UpdateDestinationRequest> {
    private final String deliveryStreamName;

    private final String currentDeliveryStreamVersionId;

    private final String destinationId;

    private final S3DestinationUpdate s3DestinationUpdate;

    private final ExtendedS3DestinationUpdate extendedS3DestinationUpdate;

    private final RedshiftDestinationUpdate redshiftDestinationUpdate;

    private final ElasticsearchDestinationUpdate elasticsearchDestinationUpdate;

    private final SplunkDestinationUpdate splunkDestinationUpdate;

    private UpdateDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamName = builder.deliveryStreamName;
        this.currentDeliveryStreamVersionId = builder.currentDeliveryStreamVersionId;
        this.destinationId = builder.destinationId;
        this.s3DestinationUpdate = builder.s3DestinationUpdate;
        this.extendedS3DestinationUpdate = builder.extendedS3DestinationUpdate;
        this.redshiftDestinationUpdate = builder.redshiftDestinationUpdate;
        this.elasticsearchDestinationUpdate = builder.elasticsearchDestinationUpdate;
        this.splunkDestinationUpdate = builder.splunkDestinationUpdate;
    }

    /**
     * <p>
     * The name of the delivery stream.
     * </p>
     * 
     * @return The name of the delivery stream.
     */
    public String deliveryStreamName() {
        return deliveryStreamName;
    }

    /**
     * <p>
     * Obtain this value from the <b>VersionId</b> result of <a>DeliveryStreamDescription</a>. This value is required,
     * and helps the service to perform conditional operations. For example, if there is an interleaving update and this
     * value is null, then the update destination fails. After the update is successful, the <b>VersionId</b> value is
     * updated. The service then performs a merge of the old configuration with the new configuration.
     * </p>
     * 
     * @return Obtain this value from the <b>VersionId</b> result of <a>DeliveryStreamDescription</a>. This value is
     *         required, and helps the service to perform conditional operations. For example, if there is an
     *         interleaving update and this value is null, then the update destination fails. After the update is
     *         successful, the <b>VersionId</b> value is updated. The service then performs a merge of the old
     *         configuration with the new configuration.
     */
    public String currentDeliveryStreamVersionId() {
        return currentDeliveryStreamVersionId;
    }

    /**
     * <p>
     * The ID of the destination.
     * </p>
     * 
     * @return The ID of the destination.
     */
    public String destinationId() {
        return destinationId;
    }

    /**
     * <p>
     * [Deprecated] Describes an update for a destination in Amazon S3.
     * </p>
     * 
     * @return [Deprecated] Describes an update for a destination in Amazon S3.
     */
    public S3DestinationUpdate s3DestinationUpdate() {
        return s3DestinationUpdate;
    }

    /**
     * <p>
     * Describes an update for a destination in Amazon S3.
     * </p>
     * 
     * @return Describes an update for a destination in Amazon S3.
     */
    public ExtendedS3DestinationUpdate extendedS3DestinationUpdate() {
        return extendedS3DestinationUpdate;
    }

    /**
     * <p>
     * Describes an update for a destination in Amazon Redshift.
     * </p>
     * 
     * @return Describes an update for a destination in Amazon Redshift.
     */
    public RedshiftDestinationUpdate redshiftDestinationUpdate() {
        return redshiftDestinationUpdate;
    }

    /**
     * <p>
     * Describes an update for a destination in Amazon ES.
     * </p>
     * 
     * @return Describes an update for a destination in Amazon ES.
     */
    public ElasticsearchDestinationUpdate elasticsearchDestinationUpdate() {
        return elasticsearchDestinationUpdate;
    }

    /**
     * <p>
     * Describes an update for a destination in Splunk.
     * </p>
     * 
     * @return Describes an update for a destination in Splunk.
     */
    public SplunkDestinationUpdate splunkDestinationUpdate() {
        return splunkDestinationUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(currentDeliveryStreamVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationId());
        hashCode = 31 * hashCode + Objects.hashCode(s3DestinationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(extendedS3DestinationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftDestinationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(elasticsearchDestinationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(splunkDestinationUpdate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDestinationRequest)) {
            return false;
        }
        UpdateDestinationRequest other = (UpdateDestinationRequest) obj;
        return Objects.equals(deliveryStreamName(), other.deliveryStreamName())
                && Objects.equals(currentDeliveryStreamVersionId(), other.currentDeliveryStreamVersionId())
                && Objects.equals(destinationId(), other.destinationId())
                && Objects.equals(s3DestinationUpdate(), other.s3DestinationUpdate())
                && Objects.equals(extendedS3DestinationUpdate(), other.extendedS3DestinationUpdate())
                && Objects.equals(redshiftDestinationUpdate(), other.redshiftDestinationUpdate())
                && Objects.equals(elasticsearchDestinationUpdate(), other.elasticsearchDestinationUpdate())
                && Objects.equals(splunkDestinationUpdate(), other.splunkDestinationUpdate());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateDestinationRequest").add("DeliveryStreamName", deliveryStreamName())
                .add("CurrentDeliveryStreamVersionId", currentDeliveryStreamVersionId()).add("DestinationId", destinationId())
                .add("S3DestinationUpdate", s3DestinationUpdate())
                .add("ExtendedS3DestinationUpdate", extendedS3DestinationUpdate())
                .add("RedshiftDestinationUpdate", redshiftDestinationUpdate())
                .add("ElasticsearchDestinationUpdate", elasticsearchDestinationUpdate())
                .add("SplunkDestinationUpdate", splunkDestinationUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryStreamName":
            return Optional.of(clazz.cast(deliveryStreamName()));
        case "CurrentDeliveryStreamVersionId":
            return Optional.of(clazz.cast(currentDeliveryStreamVersionId()));
        case "DestinationId":
            return Optional.of(clazz.cast(destinationId()));
        case "S3DestinationUpdate":
            return Optional.of(clazz.cast(s3DestinationUpdate()));
        case "ExtendedS3DestinationUpdate":
            return Optional.of(clazz.cast(extendedS3DestinationUpdate()));
        case "RedshiftDestinationUpdate":
            return Optional.of(clazz.cast(redshiftDestinationUpdate()));
        case "ElasticsearchDestinationUpdate":
            return Optional.of(clazz.cast(elasticsearchDestinationUpdate()));
        case "SplunkDestinationUpdate":
            return Optional.of(clazz.cast(splunkDestinationUpdate()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends FirehoseRequest.Builder, CopyableBuilder<Builder, UpdateDestinationRequest> {
        /**
         * <p>
         * The name of the delivery stream.
         * </p>
         * 
         * @param deliveryStreamName
         *        The name of the delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamName(String deliveryStreamName);

        /**
         * <p>
         * Obtain this value from the <b>VersionId</b> result of <a>DeliveryStreamDescription</a>. This value is
         * required, and helps the service to perform conditional operations. For example, if there is an interleaving
         * update and this value is null, then the update destination fails. After the update is successful, the
         * <b>VersionId</b> value is updated. The service then performs a merge of the old configuration with the new
         * configuration.
         * </p>
         * 
         * @param currentDeliveryStreamVersionId
         *        Obtain this value from the <b>VersionId</b> result of <a>DeliveryStreamDescription</a>. This value is
         *        required, and helps the service to perform conditional operations. For example, if there is an
         *        interleaving update and this value is null, then the update destination fails. After the update is
         *        successful, the <b>VersionId</b> value is updated. The service then performs a merge of the old
         *        configuration with the new configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentDeliveryStreamVersionId(String currentDeliveryStreamVersionId);

        /**
         * <p>
         * The ID of the destination.
         * </p>
         * 
         * @param destinationId
         *        The ID of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationId(String destinationId);

        /**
         * <p>
         * [Deprecated] Describes an update for a destination in Amazon S3.
         * </p>
         * 
         * @param s3DestinationUpdate
         *        [Deprecated] Describes an update for a destination in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DestinationUpdate(S3DestinationUpdate s3DestinationUpdate);

        /**
         * <p>
         * [Deprecated] Describes an update for a destination in Amazon S3.
         * </p>
         * This is a convenience that creates an instance of the {@link S3DestinationUpdate.Builder} avoiding the need
         * to create one manually via {@link S3DestinationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3DestinationUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #s3DestinationUpdate(S3DestinationUpdate)}.
         * 
         * @param s3DestinationUpdate
         *        a consumer that will call methods on {@link S3DestinationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DestinationUpdate(S3DestinationUpdate)
         */
        default Builder s3DestinationUpdate(Consumer<S3DestinationUpdate.Builder> s3DestinationUpdate) {
            return s3DestinationUpdate(S3DestinationUpdate.builder().apply(s3DestinationUpdate).build());
        }

        /**
         * <p>
         * Describes an update for a destination in Amazon S3.
         * </p>
         * 
         * @param extendedS3DestinationUpdate
         *        Describes an update for a destination in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedS3DestinationUpdate(ExtendedS3DestinationUpdate extendedS3DestinationUpdate);

        /**
         * <p>
         * Describes an update for a destination in Amazon S3.
         * </p>
         * This is a convenience that creates an instance of the {@link ExtendedS3DestinationUpdate.Builder} avoiding
         * the need to create one manually via {@link ExtendedS3DestinationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExtendedS3DestinationUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #extendedS3DestinationUpdate(ExtendedS3DestinationUpdate)}.
         * 
         * @param extendedS3DestinationUpdate
         *        a consumer that will call methods on {@link ExtendedS3DestinationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extendedS3DestinationUpdate(ExtendedS3DestinationUpdate)
         */
        default Builder extendedS3DestinationUpdate(Consumer<ExtendedS3DestinationUpdate.Builder> extendedS3DestinationUpdate) {
            return extendedS3DestinationUpdate(ExtendedS3DestinationUpdate.builder().apply(extendedS3DestinationUpdate).build());
        }

        /**
         * <p>
         * Describes an update for a destination in Amazon Redshift.
         * </p>
         * 
         * @param redshiftDestinationUpdate
         *        Describes an update for a destination in Amazon Redshift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftDestinationUpdate(RedshiftDestinationUpdate redshiftDestinationUpdate);

        /**
         * <p>
         * Describes an update for a destination in Amazon Redshift.
         * </p>
         * This is a convenience that creates an instance of the {@link RedshiftDestinationUpdate.Builder} avoiding the
         * need to create one manually via {@link RedshiftDestinationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link RedshiftDestinationUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #redshiftDestinationUpdate(RedshiftDestinationUpdate)}.
         * 
         * @param redshiftDestinationUpdate
         *        a consumer that will call methods on {@link RedshiftDestinationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftDestinationUpdate(RedshiftDestinationUpdate)
         */
        default Builder redshiftDestinationUpdate(Consumer<RedshiftDestinationUpdate.Builder> redshiftDestinationUpdate) {
            return redshiftDestinationUpdate(RedshiftDestinationUpdate.builder().apply(redshiftDestinationUpdate).build());
        }

        /**
         * <p>
         * Describes an update for a destination in Amazon ES.
         * </p>
         * 
         * @param elasticsearchDestinationUpdate
         *        Describes an update for a destination in Amazon ES.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchDestinationUpdate(ElasticsearchDestinationUpdate elasticsearchDestinationUpdate);

        /**
         * <p>
         * Describes an update for a destination in Amazon ES.
         * </p>
         * This is a convenience that creates an instance of the {@link ElasticsearchDestinationUpdate.Builder} avoiding
         * the need to create one manually via {@link ElasticsearchDestinationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link ElasticsearchDestinationUpdate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #elasticsearchDestinationUpdate(ElasticsearchDestinationUpdate)}.
         * 
         * @param elasticsearchDestinationUpdate
         *        a consumer that will call methods on {@link ElasticsearchDestinationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticsearchDestinationUpdate(ElasticsearchDestinationUpdate)
         */
        default Builder elasticsearchDestinationUpdate(
                Consumer<ElasticsearchDestinationUpdate.Builder> elasticsearchDestinationUpdate) {
            return elasticsearchDestinationUpdate(ElasticsearchDestinationUpdate.builder().apply(elasticsearchDestinationUpdate)
                    .build());
        }

        /**
         * <p>
         * Describes an update for a destination in Splunk.
         * </p>
         * 
         * @param splunkDestinationUpdate
         *        Describes an update for a destination in Splunk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder splunkDestinationUpdate(SplunkDestinationUpdate splunkDestinationUpdate);

        /**
         * <p>
         * Describes an update for a destination in Splunk.
         * </p>
         * This is a convenience that creates an instance of the {@link SplunkDestinationUpdate.Builder} avoiding the
         * need to create one manually via {@link SplunkDestinationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link SplunkDestinationUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #splunkDestinationUpdate(SplunkDestinationUpdate)}.
         * 
         * @param splunkDestinationUpdate
         *        a consumer that will call methods on {@link SplunkDestinationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #splunkDestinationUpdate(SplunkDestinationUpdate)
         */
        default Builder splunkDestinationUpdate(Consumer<SplunkDestinationUpdate.Builder> splunkDestinationUpdate) {
            return splunkDestinationUpdate(SplunkDestinationUpdate.builder().apply(splunkDestinationUpdate).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends FirehoseRequest.BuilderImpl implements Builder {
        private String deliveryStreamName;

        private String currentDeliveryStreamVersionId;

        private String destinationId;

        private S3DestinationUpdate s3DestinationUpdate;

        private ExtendedS3DestinationUpdate extendedS3DestinationUpdate;

        private RedshiftDestinationUpdate redshiftDestinationUpdate;

        private ElasticsearchDestinationUpdate elasticsearchDestinationUpdate;

        private SplunkDestinationUpdate splunkDestinationUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDestinationRequest model) {
            deliveryStreamName(model.deliveryStreamName);
            currentDeliveryStreamVersionId(model.currentDeliveryStreamVersionId);
            destinationId(model.destinationId);
            s3DestinationUpdate(model.s3DestinationUpdate);
            extendedS3DestinationUpdate(model.extendedS3DestinationUpdate);
            redshiftDestinationUpdate(model.redshiftDestinationUpdate);
            elasticsearchDestinationUpdate(model.elasticsearchDestinationUpdate);
            splunkDestinationUpdate(model.splunkDestinationUpdate);
        }

        public final String getDeliveryStreamName() {
            return deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final String getCurrentDeliveryStreamVersionId() {
            return currentDeliveryStreamVersionId;
        }

        @Override
        public final Builder currentDeliveryStreamVersionId(String currentDeliveryStreamVersionId) {
            this.currentDeliveryStreamVersionId = currentDeliveryStreamVersionId;
            return this;
        }

        public final void setCurrentDeliveryStreamVersionId(String currentDeliveryStreamVersionId) {
            this.currentDeliveryStreamVersionId = currentDeliveryStreamVersionId;
        }

        public final String getDestinationId() {
            return destinationId;
        }

        @Override
        public final Builder destinationId(String destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        public final void setDestinationId(String destinationId) {
            this.destinationId = destinationId;
        }

        public final S3DestinationUpdate.Builder getS3DestinationUpdate() {
            return s3DestinationUpdate != null ? s3DestinationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder s3DestinationUpdate(S3DestinationUpdate s3DestinationUpdate) {
            this.s3DestinationUpdate = s3DestinationUpdate;
            return this;
        }

        public final void setS3DestinationUpdate(S3DestinationUpdate.BuilderImpl s3DestinationUpdate) {
            this.s3DestinationUpdate = s3DestinationUpdate != null ? s3DestinationUpdate.build() : null;
        }

        public final ExtendedS3DestinationUpdate.Builder getExtendedS3DestinationUpdate() {
            return extendedS3DestinationUpdate != null ? extendedS3DestinationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder extendedS3DestinationUpdate(ExtendedS3DestinationUpdate extendedS3DestinationUpdate) {
            this.extendedS3DestinationUpdate = extendedS3DestinationUpdate;
            return this;
        }

        public final void setExtendedS3DestinationUpdate(ExtendedS3DestinationUpdate.BuilderImpl extendedS3DestinationUpdate) {
            this.extendedS3DestinationUpdate = extendedS3DestinationUpdate != null ? extendedS3DestinationUpdate.build() : null;
        }

        public final RedshiftDestinationUpdate.Builder getRedshiftDestinationUpdate() {
            return redshiftDestinationUpdate != null ? redshiftDestinationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder redshiftDestinationUpdate(RedshiftDestinationUpdate redshiftDestinationUpdate) {
            this.redshiftDestinationUpdate = redshiftDestinationUpdate;
            return this;
        }

        public final void setRedshiftDestinationUpdate(RedshiftDestinationUpdate.BuilderImpl redshiftDestinationUpdate) {
            this.redshiftDestinationUpdate = redshiftDestinationUpdate != null ? redshiftDestinationUpdate.build() : null;
        }

        public final ElasticsearchDestinationUpdate.Builder getElasticsearchDestinationUpdate() {
            return elasticsearchDestinationUpdate != null ? elasticsearchDestinationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchDestinationUpdate(ElasticsearchDestinationUpdate elasticsearchDestinationUpdate) {
            this.elasticsearchDestinationUpdate = elasticsearchDestinationUpdate;
            return this;
        }

        public final void setElasticsearchDestinationUpdate(
                ElasticsearchDestinationUpdate.BuilderImpl elasticsearchDestinationUpdate) {
            this.elasticsearchDestinationUpdate = elasticsearchDestinationUpdate != null ? elasticsearchDestinationUpdate.build()
                    : null;
        }

        public final SplunkDestinationUpdate.Builder getSplunkDestinationUpdate() {
            return splunkDestinationUpdate != null ? splunkDestinationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder splunkDestinationUpdate(SplunkDestinationUpdate splunkDestinationUpdate) {
            this.splunkDestinationUpdate = splunkDestinationUpdate;
            return this;
        }

        public final void setSplunkDestinationUpdate(SplunkDestinationUpdate.BuilderImpl splunkDestinationUpdate) {
            this.splunkDestinationUpdate = splunkDestinationUpdate != null ? splunkDestinationUpdate.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateDestinationRequest build() {
            return new UpdateDestinationRequest(this);
        }
    }
}
