/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.S3DestinationDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a destination in Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class S3DestinationDescription implements StructuredPojo,
        ToCopyableBuilder<S3DestinationDescription.Builder, S3DestinationDescription> {
    private final String roleARN;

    private final String bucketARN;

    private final String prefix;

    private final BufferingHints bufferingHints;

    private final String compressionFormat;

    private final EncryptionConfiguration encryptionConfiguration;

    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private S3DestinationDescription(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.bucketARN = builder.bucketARN;
        this.prefix = builder.prefix;
        this.bufferingHints = builder.bufferingHints;
        this.compressionFormat = builder.compressionFormat;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
    }

    /**
     * <p>
     * The ARN of the AWS credentials.
     * </p>
     * 
     * @return The ARN of the AWS credentials.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The ARN of the S3 bucket.
     * </p>
     * 
     * @return The ARN of the S3 bucket.
     */
    public String bucketARN() {
        return bucketARN;
    }

    /**
     * <p>
     * The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered S3 files. You can specify an extra
     * prefix to be added in front of the time format prefix. If the prefix ends with a slash, it appears as a folder in
     * the S3 bucket. For more information, see <a
     * href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html">Amazon S3 Object Name Format</a> in the
     * <i>Amazon Kinesis Firehose Developer Guide</i>.
     * </p>
     * 
     * @return The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered S3 files. You can specify an
     *         extra prefix to be added in front of the time format prefix. If the prefix ends with a slash, it appears
     *         as a folder in the S3 bucket. For more information, see <a
     *         href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html">Amazon S3 Object Name Format</a>
     *         in the <i>Amazon Kinesis Firehose Developer Guide</i>.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * <p>
     * The buffering option. If no value is specified, <b>BufferingHints</b> object default values are used.
     * </p>
     * 
     * @return The buffering option. If no value is specified, <b>BufferingHints</b> object default values are used.
     */
    public BufferingHints bufferingHints() {
        return bufferingHints;
    }

    /**
     * <p>
     * The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compressionFormat}
     * will return {@link CompressionFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #compressionFormatString}.
     * </p>
     * 
     * @return The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.
     * @see CompressionFormat
     */
    public CompressionFormat compressionFormat() {
        return CompressionFormat.fromValue(compressionFormat);
    }

    /**
     * <p>
     * The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compressionFormat}
     * will return {@link CompressionFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #compressionFormatString}.
     * </p>
     * 
     * @return The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.
     * @see CompressionFormat
     */
    public String compressionFormatString() {
        return compressionFormat;
    }

    /**
     * <p>
     * The encryption configuration. If no value is specified, the default is no encryption.
     * </p>
     * 
     * @return The encryption configuration. If no value is specified, the default is no encryption.
     */
    public EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * <p>
     * The CloudWatch logging options for your delivery stream.
     * </p>
     * 
     * @return The CloudWatch logging options for your delivery stream.
     */
    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(bucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(compressionFormatString());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DestinationDescription)) {
            return false;
        }
        S3DestinationDescription other = (S3DestinationDescription) obj;
        return Objects.equals(roleARN(), other.roleARN()) && Objects.equals(bucketARN(), other.bucketARN())
                && Objects.equals(prefix(), other.prefix()) && Objects.equals(bufferingHints(), other.bufferingHints())
                && Objects.equals(compressionFormatString(), other.compressionFormatString())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration())
                && Objects.equals(cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions());
    }

    @Override
    public String toString() {
        return ToString.builder("S3DestinationDescription").add("RoleARN", roleARN()).add("BucketARN", bucketARN())
                .add("Prefix", prefix()).add("BufferingHints", bufferingHints())
                .add("CompressionFormat", compressionFormatString()).add("EncryptionConfiguration", encryptionConfiguration())
                .add("CloudWatchLoggingOptions", cloudWatchLoggingOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleARN":
            return Optional.of(clazz.cast(roleARN()));
        case "BucketARN":
            return Optional.of(clazz.cast(bucketARN()));
        case "Prefix":
            return Optional.of(clazz.cast(prefix()));
        case "BufferingHints":
            return Optional.of(clazz.cast(bufferingHints()));
        case "CompressionFormat":
            return Optional.of(clazz.cast(compressionFormatString()));
        case "EncryptionConfiguration":
            return Optional.of(clazz.cast(encryptionConfiguration()));
        case "CloudWatchLoggingOptions":
            return Optional.of(clazz.cast(cloudWatchLoggingOptions()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3DestinationDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, S3DestinationDescription> {
        /**
         * <p>
         * The ARN of the AWS credentials.
         * </p>
         * 
         * @param roleARN
         *        The ARN of the AWS credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The ARN of the S3 bucket.
         * </p>
         * 
         * @param bucketARN
         *        The ARN of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketARN(String bucketARN);

        /**
         * <p>
         * The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered S3 files. You can specify an extra
         * prefix to be added in front of the time format prefix. If the prefix ends with a slash, it appears as a
         * folder in the S3 bucket. For more information, see <a
         * href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html">Amazon S3 Object Name Format</a> in
         * the <i>Amazon Kinesis Firehose Developer Guide</i>.
         * </p>
         * 
         * @param prefix
         *        The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered S3 files. You can specify
         *        an extra prefix to be added in front of the time format prefix. If the prefix ends with a slash, it
         *        appears as a folder in the S3 bucket. For more information, see <a
         *        href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html">Amazon S3 Object Name
         *        Format</a> in the <i>Amazon Kinesis Firehose Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * The buffering option. If no value is specified, <b>BufferingHints</b> object default values are used.
         * </p>
         * 
         * @param bufferingHints
         *        The buffering option. If no value is specified, <b>BufferingHints</b> object default values are used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bufferingHints(BufferingHints bufferingHints);

        /**
         * <p>
         * The buffering option. If no value is specified, <b>BufferingHints</b> object default values are used.
         * </p>
         * This is a convenience that creates an instance of the {@link BufferingHints.Builder} avoiding the need to
         * create one manually via {@link BufferingHints#builder()}.
         *
         * When the {@link Consumer} completes, {@link BufferingHints.Builder#build()} is called immediately and its
         * result is passed to {@link #bufferingHints(BufferingHints)}.
         * 
         * @param bufferingHints
         *        a consumer that will call methods on {@link BufferingHints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bufferingHints(BufferingHints)
         */
        default Builder bufferingHints(Consumer<BufferingHints.Builder> bufferingHints) {
            return bufferingHints(BufferingHints.builder().apply(bufferingHints).build());
        }

        /**
         * <p>
         * The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.
         * </p>
         * 
         * @param compressionFormat
         *        The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.
         * @see CompressionFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionFormat
         */
        Builder compressionFormat(String compressionFormat);

        /**
         * <p>
         * The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.
         * </p>
         * 
         * @param compressionFormat
         *        The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.
         * @see CompressionFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionFormat
         */
        Builder compressionFormat(CompressionFormat compressionFormat);

        /**
         * <p>
         * The encryption configuration. If no value is specified, the default is no encryption.
         * </p>
         * 
         * @param encryptionConfiguration
         *        The encryption configuration. If no value is specified, the default is no encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * The encryption configuration. If no value is specified, the default is no encryption.
         * </p>
         * This is a convenience that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding the
         * need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().apply(encryptionConfiguration).build());
        }

        /**
         * <p>
         * The CloudWatch logging options for your delivery stream.
         * </p>
         * 
         * @param cloudWatchLoggingOptions
         *        The CloudWatch logging options for your delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions);

        /**
         * <p>
         * The CloudWatch logging options for your delivery stream.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudWatchLoggingOptions.Builder} avoiding the
         * need to create one manually via {@link CloudWatchLoggingOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchLoggingOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLoggingOptions(CloudWatchLoggingOptions)}.
         * 
         * @param cloudWatchLoggingOptions
         *        a consumer that will call methods on {@link CloudWatchLoggingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOptions(CloudWatchLoggingOptions)
         */
        default Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return cloudWatchLoggingOptions(CloudWatchLoggingOptions.builder().apply(cloudWatchLoggingOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String roleARN;

        private String bucketARN;

        private String prefix;

        private BufferingHints bufferingHints;

        private String compressionFormat;

        private EncryptionConfiguration encryptionConfiguration;

        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DestinationDescription model) {
            roleARN(model.roleARN);
            bucketARN(model.bucketARN);
            prefix(model.prefix);
            bufferingHints(model.bufferingHints);
            compressionFormat(model.compressionFormat);
            encryptionConfiguration(model.encryptionConfiguration);
            cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getBucketARN() {
            return bucketARN;
        }

        @Override
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final BufferingHints.Builder getBufferingHints() {
            return bufferingHints != null ? bufferingHints.toBuilder() : null;
        }

        @Override
        public final Builder bufferingHints(BufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final void setBufferingHints(BufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        public final String getCompressionFormat() {
            return compressionFormat;
        }

        @Override
        public final Builder compressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
            return this;
        }

        @Override
        public final Builder compressionFormat(CompressionFormat compressionFormat) {
            this.compressionFormat(compressionFormat.toString());
            return this;
        }

        public final void setCompressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public S3DestinationDescription build() {
            return new S3DestinationDescription(this);
        }
    }
}
