/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.Input;

@SdkInternalApi
public class InputMarshaller {
    private static final MarshallingInfo<String> NAMEPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NamePrefix").build();
    private static final MarshallingInfo<StructuredPojo> INPUTPROCESSINGCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputProcessingConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSINPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamsInput").build();
    private static final MarshallingInfo<StructuredPojo> KINESISFIREHOSEINPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisFirehoseInput").build();
    private static final MarshallingInfo<StructuredPojo> INPUTPARALLELISM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputParallelism").build();
    private static final MarshallingInfo<StructuredPojo> INPUTSCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputSchema").build();
    private static final InputMarshaller INSTANCE = new InputMarshaller();

    public static InputMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Input input, ProtocolMarshaller protocolMarshaller) {
        if (input == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)input.namePrefix(), NAMEPREFIX_BINDING);
            protocolMarshaller.marshall((Object)input.inputProcessingConfiguration(), INPUTPROCESSINGCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)input.kinesisStreamsInput(), KINESISSTREAMSINPUT_BINDING);
            protocolMarshaller.marshall((Object)input.kinesisFirehoseInput(), KINESISFIREHOSEINPUT_BINDING);
            protocolMarshaller.marshall((Object)input.inputParallelism(), INPUTPARALLELISM_BINDING);
            protocolMarshaller.marshall((Object)input.inputSchema(), INPUTSCHEMA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

