/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionRequest;

@SdkInternalApi
public class StopStreamEncryptionRequestModelMarshaller {
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamName").build();
    private static final MarshallingInfo<String> ENCRYPTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionType").build();
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").build();
    private static final StopStreamEncryptionRequestModelMarshaller INSTANCE = new StopStreamEncryptionRequestModelMarshaller();

    public static StopStreamEncryptionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StopStreamEncryptionRequest stopStreamEncryptionRequest, ProtocolMarshaller protocolMarshaller) {
        if (stopStreamEncryptionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)stopStreamEncryptionRequest.streamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)stopStreamEncryptionRequest.encryptionTypeString(), ENCRYPTIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)stopStreamEncryptionRequest.keyId(), KEYID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

