/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.firehose.model.SourceDescription;
import software.amazon.awssdk.services.firehose.transform.KinesisStreamSourceDescriptionUnmarshaller;

public class SourceDescriptionUnmarshaller
implements Unmarshaller<SourceDescription, JsonUnmarshallerContext> {
    private static final SourceDescriptionUnmarshaller INSTANCE = new SourceDescriptionUnmarshaller();

    public SourceDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        SourceDescription.Builder sourceDescriptionBuilder = SourceDescription.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("KinesisStreamSourceDescription", targetDepth)) {
                    context.nextToken();
                    sourceDescriptionBuilder.kinesisStreamSourceDescription(KinesisStreamSourceDescriptionUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (SourceDescription)sourceDescriptionBuilder.build();
    }

    public static SourceDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

