/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.RedshiftDestinationUpdate;

@SdkInternalApi
public class RedshiftDestinationUpdateMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").build();
    private static final MarshallingInfo<String> CLUSTERJDBCURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterJDBCURL").build();
    private static final MarshallingInfo<StructuredPojo> COPYCOMMAND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CopyCommand").build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").build();
    private static final MarshallingInfo<String> PASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Password").build();
    private static final MarshallingInfo<StructuredPojo> RETRYOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetryOptions").build();
    private static final MarshallingInfo<StructuredPojo> S3UPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Update").build();
    private static final MarshallingInfo<StructuredPojo> PROCESSINGCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProcessingConfiguration").build();
    private static final MarshallingInfo<String> S3BACKUPMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BackupMode").build();
    private static final MarshallingInfo<StructuredPojo> S3BACKUPUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BackupUpdate").build();
    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHLOGGINGOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchLoggingOptions").build();
    private static final RedshiftDestinationUpdateMarshaller INSTANCE = new RedshiftDestinationUpdateMarshaller();

    public static RedshiftDestinationUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RedshiftDestinationUpdate redshiftDestinationUpdate, ProtocolMarshaller protocolMarshaller) {
        if (redshiftDestinationUpdate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)redshiftDestinationUpdate.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)redshiftDestinationUpdate.clusterJDBCURL(), CLUSTERJDBCURL_BINDING);
            protocolMarshaller.marshall((Object)redshiftDestinationUpdate.copyCommand(), COPYCOMMAND_BINDING);
            protocolMarshaller.marshall((Object)redshiftDestinationUpdate.username(), USERNAME_BINDING);
            protocolMarshaller.marshall((Object)redshiftDestinationUpdate.password(), PASSWORD_BINDING);
            protocolMarshaller.marshall((Object)redshiftDestinationUpdate.retryOptions(), RETRYOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)redshiftDestinationUpdate.s3Update(), S3UPDATE_BINDING);
            protocolMarshaller.marshall((Object)redshiftDestinationUpdate.processingConfiguration(), PROCESSINGCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)redshiftDestinationUpdate.s3BackupModeString(), S3BACKUPMODE_BINDING);
            protocolMarshaller.marshall((Object)redshiftDestinationUpdate.s3BackupUpdate(), S3BACKUPUPDATE_BINDING);
            protocolMarshaller.marshall((Object)redshiftDestinationUpdate.cloudWatchLoggingOptions(), CLOUDWATCHLOGGINGOPTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

