/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.kinesisanalytics.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * InputUpdateMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class InputUpdateMarshaller {

    private static final MarshallingInfo<String> INPUTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputId").build();
    private static final MarshallingInfo<String> NAMEPREFIXUPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NamePrefixUpdate").build();
    private static final MarshallingInfo<StructuredPojo> INPUTPROCESSINGCONFIGURATIONUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("InputProcessingConfigurationUpdate").build();
    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSINPUTUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("KinesisStreamsInputUpdate").build();
    private static final MarshallingInfo<StructuredPojo> KINESISFIREHOSEINPUTUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("KinesisFirehoseInputUpdate").build();
    private static final MarshallingInfo<StructuredPojo> INPUTSCHEMAUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("InputSchemaUpdate").build();
    private static final MarshallingInfo<StructuredPojo> INPUTPARALLELISMUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("InputParallelismUpdate").build();

    private static final InputUpdateMarshaller INSTANCE = new InputUpdateMarshaller();

    public static InputUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(InputUpdate inputUpdate, ProtocolMarshaller protocolMarshaller) {

        if (inputUpdate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(inputUpdate.inputId(), INPUTID_BINDING);

            protocolMarshaller.marshall(inputUpdate.namePrefixUpdate(), NAMEPREFIXUPDATE_BINDING);

            protocolMarshaller.marshall(inputUpdate.inputProcessingConfigurationUpdate(),
                    INPUTPROCESSINGCONFIGURATIONUPDATE_BINDING);

            protocolMarshaller.marshall(inputUpdate.kinesisStreamsInputUpdate(), KINESISSTREAMSINPUTUPDATE_BINDING);

            protocolMarshaller.marshall(inputUpdate.kinesisFirehoseInputUpdate(), KINESISFIREHOSEINPUTUPDATE_BINDING);

            protocolMarshaller.marshall(inputUpdate.inputSchemaUpdate(), INPUTSCHEMAUPDATE_BINDING);

            protocolMarshaller.marshall(inputUpdate.inputParallelismUpdate(), INPUTPARALLELISMUPDATE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
