/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.kinesis.transform.EnhancedMetricsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents enhanced metrics types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class EnhancedMetrics implements StructuredPojo, ToCopyableBuilder<EnhancedMetrics.Builder, EnhancedMetrics> {
    private final List<String> shardLevelMetrics;

    private EnhancedMetrics(BuilderImpl builder) {
        this.shardLevelMetrics = builder.shardLevelMetrics;
    }

    /**
     * <p>
     * List of shard-level metrics.
     * </p>
     * <p>
     * The following are the valid shard-level metrics. The value "<code>ALL</code>" enhances every metric.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IncomingBytes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IncomingRecords</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutgoingBytes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutgoingRecords</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WriteProvisionedThroughputExceeded</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReadProvisionedThroughputExceeded</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IteratorAgeMilliseconds</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon
     * Kinesis Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Streams Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return List of shard-level metrics.</p>
     *         <p>
     *         The following are the valid shard-level metrics. The value "<code>ALL</code>" enhances every metric.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IncomingBytes</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IncomingRecords</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OutgoingBytes</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OutgoingRecords</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WriteProvisionedThroughputExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReadProvisionedThroughputExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IteratorAgeMilliseconds</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the
     *         Amazon Kinesis Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Streams Developer
     *         Guide</i>.
     */
    public List<MetricsName> shardLevelMetrics() {
        return TypeConverter.convert(shardLevelMetrics, MetricsName::fromValue);
    }

    /**
     * <p>
     * List of shard-level metrics.
     * </p>
     * <p>
     * The following are the valid shard-level metrics. The value "<code>ALL</code>" enhances every metric.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IncomingBytes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IncomingRecords</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutgoingBytes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutgoingRecords</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WriteProvisionedThroughputExceeded</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReadProvisionedThroughputExceeded</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IteratorAgeMilliseconds</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon
     * Kinesis Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Streams Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return List of shard-level metrics.</p>
     *         <p>
     *         The following are the valid shard-level metrics. The value "<code>ALL</code>" enhances every metric.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IncomingBytes</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IncomingRecords</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OutgoingBytes</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OutgoingRecords</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WriteProvisionedThroughputExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReadProvisionedThroughputExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IteratorAgeMilliseconds</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the
     *         Amazon Kinesis Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Streams Developer
     *         Guide</i>.
     */
    public List<String> shardLevelMetricsStrings() {
        return shardLevelMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(shardLevelMetricsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnhancedMetrics)) {
            return false;
        }
        EnhancedMetrics other = (EnhancedMetrics) obj;
        return Objects.equals(shardLevelMetricsStrings(), other.shardLevelMetricsStrings());
    }

    @Override
    public String toString() {
        return ToString.builder("EnhancedMetrics").add("ShardLevelMetrics", shardLevelMetricsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShardLevelMetrics":
            return Optional.of(clazz.cast(shardLevelMetricsStrings()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnhancedMetricsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, EnhancedMetrics> {
        /**
         * <p>
         * List of shard-level metrics.
         * </p>
         * <p>
         * The following are the valid shard-level metrics. The value "<code>ALL</code>" enhances every metric.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IncomingBytes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IncomingRecords</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OutgoingBytes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OutgoingRecords</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WriteProvisionedThroughputExceeded</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReadProvisionedThroughputExceeded</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IteratorAgeMilliseconds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon
         * Kinesis Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Streams Developer Guide</i>.
         * </p>
         * 
         * @param shardLevelMetrics
         *        List of shard-level metrics.</p>
         *        <p>
         *        The following are the valid shard-level metrics. The value "<code>ALL</code>" enhances every metric.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IncomingBytes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IncomingRecords</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutgoingBytes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutgoingRecords</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WriteProvisionedThroughputExceeded</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReadProvisionedThroughputExceeded</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IteratorAgeMilliseconds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the
         *        Amazon Kinesis Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Streams Developer
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardLevelMetrics(Collection<String> shardLevelMetrics);

        /**
         * <p>
         * List of shard-level metrics.
         * </p>
         * <p>
         * The following are the valid shard-level metrics. The value "<code>ALL</code>" enhances every metric.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IncomingBytes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IncomingRecords</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OutgoingBytes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OutgoingRecords</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WriteProvisionedThroughputExceeded</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReadProvisionedThroughputExceeded</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IteratorAgeMilliseconds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon
         * Kinesis Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Streams Developer Guide</i>.
         * </p>
         * 
         * @param shardLevelMetrics
         *        List of shard-level metrics.</p>
         *        <p>
         *        The following are the valid shard-level metrics. The value "<code>ALL</code>" enhances every metric.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IncomingBytes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IncomingRecords</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutgoingBytes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutgoingRecords</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WriteProvisionedThroughputExceeded</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReadProvisionedThroughputExceeded</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IteratorAgeMilliseconds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the
         *        Amazon Kinesis Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Streams Developer
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardLevelMetrics(String... shardLevelMetrics);
    }

    static final class BuilderImpl implements Builder {
        private List<String> shardLevelMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(EnhancedMetrics model) {
            shardLevelMetrics(model.shardLevelMetrics);
        }

        public final Collection<String> getShardLevelMetrics() {
            return shardLevelMetrics;
        }

        @Override
        public final Builder shardLevelMetrics(Collection<String> shardLevelMetrics) {
            this.shardLevelMetrics = MetricsNameListCopier.copy(shardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shardLevelMetrics(String... shardLevelMetrics) {
            shardLevelMetrics(Arrays.asList(shardLevelMetrics));
            return this;
        }

        public final void setShardLevelMetrics(Collection<String> shardLevelMetrics) {
            this.shardLevelMetrics = MetricsNameListCopier.copy(shardLevelMetrics);
        }

        @Override
        public EnhancedMetrics build() {
            return new EnhancedMetrics(this);
        }
    }
}
