/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.firehose.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * SplunkDestinationConfigurationMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class SplunkDestinationConfigurationMarshaller {

    private static final MarshallingInfo<String> HECENDPOINT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HECEndpoint").build();
    private static final MarshallingInfo<String> HECENDPOINTTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HECEndpointType").build();
    private static final MarshallingInfo<String> HECTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HECToken").build();
    private static final MarshallingInfo<Integer> HECACKNOWLEDGMENTTIMEOUTINSECONDS_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("HECAcknowledgmentTimeoutInSeconds").build();
    private static final MarshallingInfo<StructuredPojo> RETRYOPTIONS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetryOptions")
            .build();
    private static final MarshallingInfo<String> S3BACKUPMODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BackupMode").build();
    private static final MarshallingInfo<StructuredPojo> S3CONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("S3Configuration").build();
    private static final MarshallingInfo<StructuredPojo> PROCESSINGCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ProcessingConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHLOGGINGOPTIONS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("CloudWatchLoggingOptions").build();

    private static final SplunkDestinationConfigurationMarshaller INSTANCE = new SplunkDestinationConfigurationMarshaller();

    public static SplunkDestinationConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(SplunkDestinationConfiguration splunkDestinationConfiguration, ProtocolMarshaller protocolMarshaller) {

        if (splunkDestinationConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(splunkDestinationConfiguration.hecEndpoint(), HECENDPOINT_BINDING);

            protocolMarshaller.marshall(splunkDestinationConfiguration.hecEndpointTypeString(), HECENDPOINTTYPE_BINDING);

            protocolMarshaller.marshall(splunkDestinationConfiguration.hecToken(), HECTOKEN_BINDING);

            protocolMarshaller.marshall(splunkDestinationConfiguration.hecAcknowledgmentTimeoutInSeconds(),
                    HECACKNOWLEDGMENTTIMEOUTINSECONDS_BINDING);

            protocolMarshaller.marshall(splunkDestinationConfiguration.retryOptions(), RETRYOPTIONS_BINDING);

            protocolMarshaller.marshall(splunkDestinationConfiguration.s3BackupModeString(), S3BACKUPMODE_BINDING);

            protocolMarshaller.marshall(splunkDestinationConfiguration.s3Configuration(), S3CONFIGURATION_BINDING);

            protocolMarshaller
                    .marshall(splunkDestinationConfiguration.processingConfiguration(), PROCESSINGCONFIGURATION_BINDING);

            protocolMarshaller.marshall(splunkDestinationConfiguration.cloudWatchLoggingOptions(),
                    CLOUDWATCHLOGGINGOPTIONS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
