/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.InputParallelism;
import software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfiguration;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseInput;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsInput;
import software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Input
implements StructuredPojo,
ToCopyableBuilder<Builder, Input> {
    private final String namePrefix;
    private final InputProcessingConfiguration inputProcessingConfiguration;
    private final KinesisStreamsInput kinesisStreamsInput;
    private final KinesisFirehoseInput kinesisFirehoseInput;
    private final InputParallelism inputParallelism;
    private final SourceSchema inputSchema;

    private Input(BuilderImpl builder) {
        this.namePrefix = builder.namePrefix;
        this.inputProcessingConfiguration = builder.inputProcessingConfiguration;
        this.kinesisStreamsInput = builder.kinesisStreamsInput;
        this.kinesisFirehoseInput = builder.kinesisFirehoseInput;
        this.inputParallelism = builder.inputParallelism;
        this.inputSchema = builder.inputSchema;
    }

    public String namePrefix() {
        return this.namePrefix;
    }

    public InputProcessingConfiguration inputProcessingConfiguration() {
        return this.inputProcessingConfiguration;
    }

    public KinesisStreamsInput kinesisStreamsInput() {
        return this.kinesisStreamsInput;
    }

    public KinesisFirehoseInput kinesisFirehoseInput() {
        return this.kinesisFirehoseInput;
    }

    public InputParallelism inputParallelism() {
        return this.inputParallelism;
    }

    public SourceSchema inputSchema() {
        return this.inputSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputProcessingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamsInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisFirehoseInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputParallelism());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSchema());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Input)) {
            return false;
        }
        Input other = (Input)obj;
        return Objects.equals(this.namePrefix(), other.namePrefix()) && Objects.equals(this.inputProcessingConfiguration(), other.inputProcessingConfiguration()) && Objects.equals(this.kinesisStreamsInput(), other.kinesisStreamsInput()) && Objects.equals(this.kinesisFirehoseInput(), other.kinesisFirehoseInput()) && Objects.equals(this.inputParallelism(), other.inputParallelism()) && Objects.equals(this.inputSchema(), other.inputSchema());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.namePrefix() != null) {
            sb.append("NamePrefix: ").append(this.namePrefix()).append(",");
        }
        if (this.inputProcessingConfiguration() != null) {
            sb.append("InputProcessingConfiguration: ").append(this.inputProcessingConfiguration()).append(",");
        }
        if (this.kinesisStreamsInput() != null) {
            sb.append("KinesisStreamsInput: ").append(this.kinesisStreamsInput()).append(",");
        }
        if (this.kinesisFirehoseInput() != null) {
            sb.append("KinesisFirehoseInput: ").append(this.kinesisFirehoseInput()).append(",");
        }
        if (this.inputParallelism() != null) {
            sb.append("InputParallelism: ").append(this.inputParallelism()).append(",");
        }
        if (this.inputSchema() != null) {
            sb.append("InputSchema: ").append(this.inputSchema()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NamePrefix": {
                return Optional.of(clazz.cast(this.namePrefix()));
            }
            case "InputProcessingConfiguration": {
                return Optional.of(clazz.cast(this.inputProcessingConfiguration()));
            }
            case "KinesisStreamsInput": {
                return Optional.of(clazz.cast(this.kinesisStreamsInput()));
            }
            case "KinesisFirehoseInput": {
                return Optional.of(clazz.cast(this.kinesisFirehoseInput()));
            }
            case "InputParallelism": {
                return Optional.of(clazz.cast(this.inputParallelism()));
            }
            case "InputSchema": {
                return Optional.of(clazz.cast(this.inputSchema()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String namePrefix;
        private InputProcessingConfiguration inputProcessingConfiguration;
        private KinesisStreamsInput kinesisStreamsInput;
        private KinesisFirehoseInput kinesisFirehoseInput;
        private InputParallelism inputParallelism;
        private SourceSchema inputSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(Input model) {
            this.namePrefix(model.namePrefix);
            this.inputProcessingConfiguration(model.inputProcessingConfiguration);
            this.kinesisStreamsInput(model.kinesisStreamsInput);
            this.kinesisFirehoseInput(model.kinesisFirehoseInput);
            this.inputParallelism(model.inputParallelism);
            this.inputSchema(model.inputSchema);
        }

        public final String getNamePrefix() {
            return this.namePrefix;
        }

        @Override
        public final Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public final void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        public final InputProcessingConfiguration.Builder getInputProcessingConfiguration() {
            return this.inputProcessingConfiguration != null ? this.inputProcessingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder inputProcessingConfiguration(InputProcessingConfiguration inputProcessingConfiguration) {
            this.inputProcessingConfiguration = inputProcessingConfiguration;
            return this;
        }

        public final void setInputProcessingConfiguration(InputProcessingConfiguration.BuilderImpl inputProcessingConfiguration) {
            this.inputProcessingConfiguration = inputProcessingConfiguration != null ? inputProcessingConfiguration.build() : null;
        }

        public final KinesisStreamsInput.Builder getKinesisStreamsInput() {
            return this.kinesisStreamsInput != null ? this.kinesisStreamsInput.toBuilder() : null;
        }

        @Override
        public final Builder kinesisStreamsInput(KinesisStreamsInput kinesisStreamsInput) {
            this.kinesisStreamsInput = kinesisStreamsInput;
            return this;
        }

        public final void setKinesisStreamsInput(KinesisStreamsInput.BuilderImpl kinesisStreamsInput) {
            this.kinesisStreamsInput = kinesisStreamsInput != null ? kinesisStreamsInput.build() : null;
        }

        public final KinesisFirehoseInput.Builder getKinesisFirehoseInput() {
            return this.kinesisFirehoseInput != null ? this.kinesisFirehoseInput.toBuilder() : null;
        }

        @Override
        public final Builder kinesisFirehoseInput(KinesisFirehoseInput kinesisFirehoseInput) {
            this.kinesisFirehoseInput = kinesisFirehoseInput;
            return this;
        }

        public final void setKinesisFirehoseInput(KinesisFirehoseInput.BuilderImpl kinesisFirehoseInput) {
            this.kinesisFirehoseInput = kinesisFirehoseInput != null ? kinesisFirehoseInput.build() : null;
        }

        public final InputParallelism.Builder getInputParallelism() {
            return this.inputParallelism != null ? this.inputParallelism.toBuilder() : null;
        }

        @Override
        public final Builder inputParallelism(InputParallelism inputParallelism) {
            this.inputParallelism = inputParallelism;
            return this;
        }

        public final void setInputParallelism(InputParallelism.BuilderImpl inputParallelism) {
            this.inputParallelism = inputParallelism != null ? inputParallelism.build() : null;
        }

        public final SourceSchema.Builder getInputSchema() {
            return this.inputSchema != null ? this.inputSchema.toBuilder() : null;
        }

        @Override
        public final Builder inputSchema(SourceSchema inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public final void setInputSchema(SourceSchema.BuilderImpl inputSchema) {
            this.inputSchema = inputSchema != null ? inputSchema.build() : null;
        }

        public Input build() {
            return new Input(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Input> {
        public Builder namePrefix(String var1);

        public Builder inputProcessingConfiguration(InputProcessingConfiguration var1);

        default public Builder inputProcessingConfiguration(Consumer<InputProcessingConfiguration.Builder> inputProcessingConfiguration) {
            return this.inputProcessingConfiguration((InputProcessingConfiguration)((InputProcessingConfiguration.Builder)InputProcessingConfiguration.builder().apply(inputProcessingConfiguration)).build());
        }

        public Builder kinesisStreamsInput(KinesisStreamsInput var1);

        default public Builder kinesisStreamsInput(Consumer<KinesisStreamsInput.Builder> kinesisStreamsInput) {
            return this.kinesisStreamsInput((KinesisStreamsInput)((KinesisStreamsInput.Builder)KinesisStreamsInput.builder().apply(kinesisStreamsInput)).build());
        }

        public Builder kinesisFirehoseInput(KinesisFirehoseInput var1);

        default public Builder kinesisFirehoseInput(Consumer<KinesisFirehoseInput.Builder> kinesisFirehoseInput) {
            return this.kinesisFirehoseInput((KinesisFirehoseInput)((KinesisFirehoseInput.Builder)KinesisFirehoseInput.builder().apply(kinesisFirehoseInput)).build());
        }

        public Builder inputParallelism(InputParallelism var1);

        default public Builder inputParallelism(Consumer<InputParallelism.Builder> inputParallelism) {
            return this.inputParallelism((InputParallelism)((InputParallelism.Builder)InputParallelism.builder().apply(inputParallelism)).build());
        }

        public Builder inputSchema(SourceSchema var1);

        default public Builder inputSchema(Consumer<SourceSchema.Builder> inputSchema) {
            return this.inputSchema((SourceSchema)((SourceSchema.Builder)SourceSchema.builder().apply(inputSchema)).build());
        }
    }
}

