/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.StreamDescriptionSummary;

@SdkInternalApi
public class StreamDescriptionSummaryMarshaller {
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamName").build();
    private static final MarshallingInfo<String> STREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamARN").build();
    private static final MarshallingInfo<String> STREAMSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamStatus").build();
    private static final MarshallingInfo<Integer> RETENTIONPERIODHOURS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetentionPeriodHours").build();
    private static final MarshallingInfo<Instant> STREAMCREATIONTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamCreationTimestamp").build();
    private static final MarshallingInfo<List> ENHANCEDMONITORING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnhancedMonitoring").build();
    private static final MarshallingInfo<String> ENCRYPTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionType").build();
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").build();
    private static final MarshallingInfo<Integer> OPENSHARDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OpenShardCount").build();
    private static final StreamDescriptionSummaryMarshaller INSTANCE = new StreamDescriptionSummaryMarshaller();

    public static StreamDescriptionSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StreamDescriptionSummary streamDescriptionSummary, ProtocolMarshaller protocolMarshaller) {
        if (streamDescriptionSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)streamDescriptionSummary.streamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)streamDescriptionSummary.streamARN(), STREAMARN_BINDING);
            protocolMarshaller.marshall((Object)streamDescriptionSummary.streamStatusString(), STREAMSTATUS_BINDING);
            protocolMarshaller.marshall((Object)streamDescriptionSummary.retentionPeriodHours(), RETENTIONPERIODHOURS_BINDING);
            protocolMarshaller.marshall((Object)streamDescriptionSummary.streamCreationTimestamp(), STREAMCREATIONTIMESTAMP_BINDING);
            protocolMarshaller.marshall(streamDescriptionSummary.enhancedMonitoring(), ENHANCEDMONITORING_BINDING);
            protocolMarshaller.marshall((Object)streamDescriptionSummary.encryptionTypeString(), ENCRYPTIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)streamDescriptionSummary.keyId(), KEYID_BINDING);
            protocolMarshaller.marshall((Object)streamDescriptionSummary.openShardCount(), OPENSHARDCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

