/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import java.nio.ByteBuffer;
import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.Record;

@SdkInternalApi
public class RecordMarshaller {
    private static final MarshallingInfo<String> SEQUENCENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SequenceNumber").build();
    private static final MarshallingInfo<Instant> APPROXIMATEARRIVALTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApproximateArrivalTimestamp").build();
    private static final MarshallingInfo<ByteBuffer> DATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Data").build();
    private static final MarshallingInfo<String> PARTITIONKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartitionKey").build();
    private static final MarshallingInfo<String> ENCRYPTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionType").build();
    private static final RecordMarshaller INSTANCE = new RecordMarshaller();

    public static RecordMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Record record, ProtocolMarshaller protocolMarshaller) {
        if (record == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)record.sequenceNumber(), SEQUENCENUMBER_BINDING);
            protocolMarshaller.marshall((Object)record.approximateArrivalTimestamp(), APPROXIMATEARRIVALTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)record.data(), DATA_BINDING);
            protocolMarshaller.marshall((Object)record.partitionKey(), PARTITIONKEY_BINDING);
            protocolMarshaller.marshall((Object)record.encryptionTypeString(), ENCRYPTIONTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

