/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.kinesis.model.Record;
import software.amazon.awssdk.services.kinesis.model.RecordListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetRecordsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetRecordsResponse> {
    private final List<Record> records;
    private final String nextShardIterator;
    private final Long millisBehindLatest;

    private GetRecordsResponse(BuilderImpl builder) {
        this.records = builder.records;
        this.nextShardIterator = builder.nextShardIterator;
        this.millisBehindLatest = builder.millisBehindLatest;
    }

    public List<Record> records() {
        return this.records;
    }

    public String nextShardIterator() {
        return this.nextShardIterator;
    }

    public Long millisBehindLatest() {
        return this.millisBehindLatest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.records());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextShardIterator());
        hashCode = 31 * hashCode + Objects.hashCode(this.millisBehindLatest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecordsResponse)) {
            return false;
        }
        GetRecordsResponse other = (GetRecordsResponse)((Object)obj);
        return Objects.equals(this.records(), other.records()) && Objects.equals(this.nextShardIterator(), other.nextShardIterator()) && Objects.equals(this.millisBehindLatest(), other.millisBehindLatest());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.records() != null) {
            sb.append("Records: ").append(this.records()).append(",");
        }
        if (this.nextShardIterator() != null) {
            sb.append("NextShardIterator: ").append(this.nextShardIterator()).append(",");
        }
        if (this.millisBehindLatest() != null) {
            sb.append("MillisBehindLatest: ").append(this.millisBehindLatest()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Records": {
                return Optional.of(clazz.cast(this.records()));
            }
            case "NextShardIterator": {
                return Optional.of(clazz.cast(this.nextShardIterator()));
            }
            case "MillisBehindLatest": {
                return Optional.of(clazz.cast(this.millisBehindLatest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Record> records;
        private String nextShardIterator;
        private Long millisBehindLatest;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecordsResponse model) {
            this.records(model.records);
            this.nextShardIterator(model.nextShardIterator);
            this.millisBehindLatest(model.millisBehindLatest);
        }

        public final Collection<Record.Builder> getRecords() {
            return this.records != null ? (Collection)this.records.stream().map(Record::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = RecordListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = RecordListCopier.copyFromBuilder(records);
        }

        public final String getNextShardIterator() {
            return this.nextShardIterator;
        }

        @Override
        public final Builder nextShardIterator(String nextShardIterator) {
            this.nextShardIterator = nextShardIterator;
            return this;
        }

        public final void setNextShardIterator(String nextShardIterator) {
            this.nextShardIterator = nextShardIterator;
        }

        public final Long getMillisBehindLatest() {
            return this.millisBehindLatest;
        }

        @Override
        public final Builder millisBehindLatest(Long millisBehindLatest) {
            this.millisBehindLatest = millisBehindLatest;
            return this;
        }

        public final void setMillisBehindLatest(Long millisBehindLatest) {
            this.millisBehindLatest = millisBehindLatest;
        }

        public GetRecordsResponse build() {
            return new GetRecordsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetRecordsResponse> {
        public Builder records(Collection<Record> var1);

        public Builder records(Record ... var1);

        public Builder nextShardIterator(String var1);

        public Builder millisBehindLatest(Long var1);
    }
}

