/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.SplunkDestinationUpdate;

@SdkInternalApi
public class SplunkDestinationUpdateMarshaller {
    private static final MarshallingInfo<String> HECENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HECEndpoint").build();
    private static final MarshallingInfo<String> HECENDPOINTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HECEndpointType").build();
    private static final MarshallingInfo<String> HECTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HECToken").build();
    private static final MarshallingInfo<Integer> HECACKNOWLEDGMENTTIMEOUTINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HECAcknowledgmentTimeoutInSeconds").build();
    private static final MarshallingInfo<StructuredPojo> RETRYOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetryOptions").build();
    private static final MarshallingInfo<String> S3BACKUPMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BackupMode").build();
    private static final MarshallingInfo<StructuredPojo> S3UPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Update").build();
    private static final MarshallingInfo<StructuredPojo> PROCESSINGCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProcessingConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHLOGGINGOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchLoggingOptions").build();
    private static final SplunkDestinationUpdateMarshaller INSTANCE = new SplunkDestinationUpdateMarshaller();

    public static SplunkDestinationUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SplunkDestinationUpdate splunkDestinationUpdate, ProtocolMarshaller protocolMarshaller) {
        if (splunkDestinationUpdate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)splunkDestinationUpdate.hecEndpoint(), HECENDPOINT_BINDING);
            protocolMarshaller.marshall((Object)splunkDestinationUpdate.hecEndpointTypeString(), HECENDPOINTTYPE_BINDING);
            protocolMarshaller.marshall((Object)splunkDestinationUpdate.hecToken(), HECTOKEN_BINDING);
            protocolMarshaller.marshall((Object)splunkDestinationUpdate.hecAcknowledgmentTimeoutInSeconds(), HECACKNOWLEDGMENTTIMEOUTINSECONDS_BINDING);
            protocolMarshaller.marshall((Object)splunkDestinationUpdate.retryOptions(), RETRYOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)splunkDestinationUpdate.s3BackupModeString(), S3BACKUPMODE_BINDING);
            protocolMarshaller.marshall((Object)splunkDestinationUpdate.s3Update(), S3UPDATE_BINDING);
            protocolMarshaller.marshall((Object)splunkDestinationUpdate.processingConfiguration(), PROCESSINGCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)splunkDestinationUpdate.cloudWatchLoggingOptions(), CLOUDWATCHLOGGINGOPTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

