/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.KinesisStreamSourceDescription;

@SdkInternalApi
public class KinesisStreamSourceDescriptionMarshaller {
    private static final MarshallingInfo<String> KINESISSTREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamARN").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").build();
    private static final MarshallingInfo<Instant> DELIVERYSTARTTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStartTimestamp").build();
    private static final KinesisStreamSourceDescriptionMarshaller INSTANCE = new KinesisStreamSourceDescriptionMarshaller();

    public static KinesisStreamSourceDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KinesisStreamSourceDescription kinesisStreamSourceDescription, ProtocolMarshaller protocolMarshaller) {
        if (kinesisStreamSourceDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)kinesisStreamSourceDescription.kinesisStreamARN(), KINESISSTREAMARN_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamSourceDescription.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamSourceDescription.deliveryStartTimestamp(), DELIVERYSTARTTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

