/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.KinesisStreamSourceConfiguration;

@SdkInternalApi
public class KinesisStreamSourceConfigurationMarshaller {
    private static final MarshallingInfo<String> KINESISSTREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamARN").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").build();
    private static final KinesisStreamSourceConfigurationMarshaller INSTANCE = new KinesisStreamSourceConfigurationMarshaller();

    public static KinesisStreamSourceConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KinesisStreamSourceConfiguration kinesisStreamSourceConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (kinesisStreamSourceConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)kinesisStreamSourceConfiguration.kinesisStreamARN(), KINESISSTREAMARN_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamSourceConfiguration.roleARN(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

