/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.ElasticsearchBufferingHints;

@SdkInternalApi
public class ElasticsearchBufferingHintsMarshaller {
    private static final MarshallingInfo<Integer> INTERVALINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IntervalInSeconds").build();
    private static final MarshallingInfo<Integer> SIZEINMBS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeInMBs").build();
    private static final ElasticsearchBufferingHintsMarshaller INSTANCE = new ElasticsearchBufferingHintsMarshaller();

    public static ElasticsearchBufferingHintsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ElasticsearchBufferingHints elasticsearchBufferingHints, ProtocolMarshaller protocolMarshaller) {
        if (elasticsearchBufferingHints == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)elasticsearchBufferingHints.intervalInSeconds(), INTERVALINSECONDS_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchBufferingHints.sizeInMBs(), SIZEINMBS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

