/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.OutputUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes updates to the output configuration identified by the <code>OutputId</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class OutputUpdate implements StructuredPojo, ToCopyableBuilder<OutputUpdate.Builder, OutputUpdate> {
    private final String outputId;

    private final String nameUpdate;

    private final KinesisStreamsOutputUpdate kinesisStreamsOutputUpdate;

    private final KinesisFirehoseOutputUpdate kinesisFirehoseOutputUpdate;

    private final DestinationSchema destinationSchemaUpdate;

    private OutputUpdate(BuilderImpl builder) {
        this.outputId = builder.outputId;
        this.nameUpdate = builder.nameUpdate;
        this.kinesisStreamsOutputUpdate = builder.kinesisStreamsOutputUpdate;
        this.kinesisFirehoseOutputUpdate = builder.kinesisFirehoseOutputUpdate;
        this.destinationSchemaUpdate = builder.destinationSchemaUpdate;
    }

    /**
     * <p>
     * Identifies the specific output configuration that you want to update.
     * </p>
     * 
     * @return Identifies the specific output configuration that you want to update.
     */
    public String outputId() {
        return outputId;
    }

    /**
     * <p>
     * If you want to specify a different in-application stream for this output configuration, use this field to specify
     * the new in-application stream name.
     * </p>
     * 
     * @return If you want to specify a different in-application stream for this output configuration, use this field to
     *         specify the new in-application stream name.
     */
    public String nameUpdate() {
        return nameUpdate;
    }

    /**
     * <p>
     * Describes an Amazon Kinesis stream as the destination for the output.
     * </p>
     * 
     * @return Describes an Amazon Kinesis stream as the destination for the output.
     */
    public KinesisStreamsOutputUpdate kinesisStreamsOutputUpdate() {
        return kinesisStreamsOutputUpdate;
    }

    /**
     * <p>
     * Describes a Amazon Kinesis Firehose delivery stream as the destination for the output.
     * </p>
     * 
     * @return Describes a Amazon Kinesis Firehose delivery stream as the destination for the output.
     */
    public KinesisFirehoseOutputUpdate kinesisFirehoseOutputUpdate() {
        return kinesisFirehoseOutputUpdate;
    }

    /**
     * Returns the value of the DestinationSchemaUpdate property for this object.
     * 
     * @return The value of the DestinationSchemaUpdate property for this object.
     */
    public DestinationSchema destinationSchemaUpdate() {
        return destinationSchemaUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputId());
        hashCode = 31 * hashCode + Objects.hashCode(nameUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamsOutputUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisFirehoseOutputUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(destinationSchemaUpdate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputUpdate)) {
            return false;
        }
        OutputUpdate other = (OutputUpdate) obj;
        return Objects.equals(outputId(), other.outputId()) && Objects.equals(nameUpdate(), other.nameUpdate())
                && Objects.equals(kinesisStreamsOutputUpdate(), other.kinesisStreamsOutputUpdate())
                && Objects.equals(kinesisFirehoseOutputUpdate(), other.kinesisFirehoseOutputUpdate())
                && Objects.equals(destinationSchemaUpdate(), other.destinationSchemaUpdate());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (outputId() != null) {
            sb.append("OutputId: ").append(outputId()).append(",");
        }
        if (nameUpdate() != null) {
            sb.append("NameUpdate: ").append(nameUpdate()).append(",");
        }
        if (kinesisStreamsOutputUpdate() != null) {
            sb.append("KinesisStreamsOutputUpdate: ").append(kinesisStreamsOutputUpdate()).append(",");
        }
        if (kinesisFirehoseOutputUpdate() != null) {
            sb.append("KinesisFirehoseOutputUpdate: ").append(kinesisFirehoseOutputUpdate()).append(",");
        }
        if (destinationSchemaUpdate() != null) {
            sb.append("DestinationSchemaUpdate: ").append(destinationSchemaUpdate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputId":
            return Optional.of(clazz.cast(outputId()));
        case "NameUpdate":
            return Optional.of(clazz.cast(nameUpdate()));
        case "KinesisStreamsOutputUpdate":
            return Optional.of(clazz.cast(kinesisStreamsOutputUpdate()));
        case "KinesisFirehoseOutputUpdate":
            return Optional.of(clazz.cast(kinesisFirehoseOutputUpdate()));
        case "DestinationSchemaUpdate":
            return Optional.of(clazz.cast(destinationSchemaUpdate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, OutputUpdate> {
        /**
         * <p>
         * Identifies the specific output configuration that you want to update.
         * </p>
         * 
         * @param outputId
         *        Identifies the specific output configuration that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputId(String outputId);

        /**
         * <p>
         * If you want to specify a different in-application stream for this output configuration, use this field to
         * specify the new in-application stream name.
         * </p>
         * 
         * @param nameUpdate
         *        If you want to specify a different in-application stream for this output configuration, use this field
         *        to specify the new in-application stream name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameUpdate(String nameUpdate);

        /**
         * <p>
         * Describes an Amazon Kinesis stream as the destination for the output.
         * </p>
         * 
         * @param kinesisStreamsOutputUpdate
         *        Describes an Amazon Kinesis stream as the destination for the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamsOutputUpdate(KinesisStreamsOutputUpdate kinesisStreamsOutputUpdate);

        /**
         * <p>
         * Describes an Amazon Kinesis stream as the destination for the output.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisStreamsOutputUpdate.Builder} avoiding the
         * need to create one manually via {@link KinesisStreamsOutputUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisStreamsOutputUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #kinesisStreamsOutputUpdate(KinesisStreamsOutputUpdate)}.
         * 
         * @param kinesisStreamsOutputUpdate
         *        a consumer that will call methods on {@link KinesisStreamsOutputUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisStreamsOutputUpdate(KinesisStreamsOutputUpdate)
         */
        default Builder kinesisStreamsOutputUpdate(Consumer<KinesisStreamsOutputUpdate.Builder> kinesisStreamsOutputUpdate) {
            return kinesisStreamsOutputUpdate(KinesisStreamsOutputUpdate.builder().apply(kinesisStreamsOutputUpdate).build());
        }

        /**
         * <p>
         * Describes a Amazon Kinesis Firehose delivery stream as the destination for the output.
         * </p>
         * 
         * @param kinesisFirehoseOutputUpdate
         *        Describes a Amazon Kinesis Firehose delivery stream as the destination for the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisFirehoseOutputUpdate(KinesisFirehoseOutputUpdate kinesisFirehoseOutputUpdate);

        /**
         * <p>
         * Describes a Amazon Kinesis Firehose delivery stream as the destination for the output.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisFirehoseOutputUpdate.Builder} avoiding
         * the need to create one manually via {@link KinesisFirehoseOutputUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisFirehoseOutputUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #kinesisFirehoseOutputUpdate(KinesisFirehoseOutputUpdate)}.
         * 
         * @param kinesisFirehoseOutputUpdate
         *        a consumer that will call methods on {@link KinesisFirehoseOutputUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisFirehoseOutputUpdate(KinesisFirehoseOutputUpdate)
         */
        default Builder kinesisFirehoseOutputUpdate(Consumer<KinesisFirehoseOutputUpdate.Builder> kinesisFirehoseOutputUpdate) {
            return kinesisFirehoseOutputUpdate(KinesisFirehoseOutputUpdate.builder().apply(kinesisFirehoseOutputUpdate).build());
        }

        /**
         * Sets the value of the DestinationSchemaUpdate property for this object.
         *
         * @param destinationSchemaUpdate
         *        The new value for the DestinationSchemaUpdate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationSchemaUpdate(DestinationSchema destinationSchemaUpdate);

        /**
         * Sets the value of the DestinationSchemaUpdate property for this object.
         *
         * This is a convenience that creates an instance of the {@link DestinationSchema.Builder} avoiding the need to
         * create one manually via {@link DestinationSchema#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationSchemaUpdate(DestinationSchema)}.
         * 
         * @param destinationSchemaUpdate
         *        a consumer that will call methods on {@link DestinationSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationSchemaUpdate(DestinationSchema)
         */
        default Builder destinationSchemaUpdate(Consumer<DestinationSchema.Builder> destinationSchemaUpdate) {
            return destinationSchemaUpdate(DestinationSchema.builder().apply(destinationSchemaUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String outputId;

        private String nameUpdate;

        private KinesisStreamsOutputUpdate kinesisStreamsOutputUpdate;

        private KinesisFirehoseOutputUpdate kinesisFirehoseOutputUpdate;

        private DestinationSchema destinationSchemaUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputUpdate model) {
            outputId(model.outputId);
            nameUpdate(model.nameUpdate);
            kinesisStreamsOutputUpdate(model.kinesisStreamsOutputUpdate);
            kinesisFirehoseOutputUpdate(model.kinesisFirehoseOutputUpdate);
            destinationSchemaUpdate(model.destinationSchemaUpdate);
        }

        public final String getOutputId() {
            return outputId;
        }

        @Override
        public final Builder outputId(String outputId) {
            this.outputId = outputId;
            return this;
        }

        public final void setOutputId(String outputId) {
            this.outputId = outputId;
        }

        public final String getNameUpdate() {
            return nameUpdate;
        }

        @Override
        public final Builder nameUpdate(String nameUpdate) {
            this.nameUpdate = nameUpdate;
            return this;
        }

        public final void setNameUpdate(String nameUpdate) {
            this.nameUpdate = nameUpdate;
        }

        public final KinesisStreamsOutputUpdate.Builder getKinesisStreamsOutputUpdate() {
            return kinesisStreamsOutputUpdate != null ? kinesisStreamsOutputUpdate.toBuilder() : null;
        }

        @Override
        public final Builder kinesisStreamsOutputUpdate(KinesisStreamsOutputUpdate kinesisStreamsOutputUpdate) {
            this.kinesisStreamsOutputUpdate = kinesisStreamsOutputUpdate;
            return this;
        }

        public final void setKinesisStreamsOutputUpdate(KinesisStreamsOutputUpdate.BuilderImpl kinesisStreamsOutputUpdate) {
            this.kinesisStreamsOutputUpdate = kinesisStreamsOutputUpdate != null ? kinesisStreamsOutputUpdate.build() : null;
        }

        public final KinesisFirehoseOutputUpdate.Builder getKinesisFirehoseOutputUpdate() {
            return kinesisFirehoseOutputUpdate != null ? kinesisFirehoseOutputUpdate.toBuilder() : null;
        }

        @Override
        public final Builder kinesisFirehoseOutputUpdate(KinesisFirehoseOutputUpdate kinesisFirehoseOutputUpdate) {
            this.kinesisFirehoseOutputUpdate = kinesisFirehoseOutputUpdate;
            return this;
        }

        public final void setKinesisFirehoseOutputUpdate(KinesisFirehoseOutputUpdate.BuilderImpl kinesisFirehoseOutputUpdate) {
            this.kinesisFirehoseOutputUpdate = kinesisFirehoseOutputUpdate != null ? kinesisFirehoseOutputUpdate.build() : null;
        }

        public final DestinationSchema.Builder getDestinationSchemaUpdate() {
            return destinationSchemaUpdate != null ? destinationSchemaUpdate.toBuilder() : null;
        }

        @Override
        public final Builder destinationSchemaUpdate(DestinationSchema destinationSchemaUpdate) {
            this.destinationSchemaUpdate = destinationSchemaUpdate;
            return this;
        }

        public final void setDestinationSchemaUpdate(DestinationSchema.BuilderImpl destinationSchemaUpdate) {
            this.destinationSchemaUpdate = destinationSchemaUpdate != null ? destinationSchemaUpdate.build() : null;
        }

        @Override
        public OutputUpdate build() {
            return new OutputUpdate(this);
        }
    }
}
