/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes updates to a specific input configuration (identified by the <code>InputId</code> of an application).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InputUpdate implements StructuredPojo, ToCopyableBuilder<InputUpdate.Builder, InputUpdate> {
    private final String inputId;

    private final String namePrefixUpdate;

    private final InputProcessingConfigurationUpdate inputProcessingConfigurationUpdate;

    private final KinesisStreamsInputUpdate kinesisStreamsInputUpdate;

    private final KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate;

    private final InputSchemaUpdate inputSchemaUpdate;

    private final InputParallelismUpdate inputParallelismUpdate;

    private InputUpdate(BuilderImpl builder) {
        this.inputId = builder.inputId;
        this.namePrefixUpdate = builder.namePrefixUpdate;
        this.inputProcessingConfigurationUpdate = builder.inputProcessingConfigurationUpdate;
        this.kinesisStreamsInputUpdate = builder.kinesisStreamsInputUpdate;
        this.kinesisFirehoseInputUpdate = builder.kinesisFirehoseInputUpdate;
        this.inputSchemaUpdate = builder.inputSchemaUpdate;
        this.inputParallelismUpdate = builder.inputParallelismUpdate;
    }

    /**
     * <p>
     * Input ID of the application input to be updated.
     * </p>
     * 
     * @return Input ID of the application input to be updated.
     */
    public String inputId() {
        return inputId;
    }

    /**
     * <p>
     * Name prefix for in-application streams that Amazon Kinesis Analytics creates for the specific streaming source.
     * </p>
     * 
     * @return Name prefix for in-application streams that Amazon Kinesis Analytics creates for the specific streaming
     *         source.
     */
    public String namePrefixUpdate() {
        return namePrefixUpdate;
    }

    /**
     * <p>
     * Describes updates for an input processing configuration.
     * </p>
     * 
     * @return Describes updates for an input processing configuration.
     */
    public InputProcessingConfigurationUpdate inputProcessingConfigurationUpdate() {
        return inputProcessingConfigurationUpdate;
    }

    /**
     * <p>
     * If a Amazon Kinesis stream is the streaming source to be updated, provides an updated stream ARN and IAM role
     * ARN.
     * </p>
     * 
     * @return If a Amazon Kinesis stream is the streaming source to be updated, provides an updated stream ARN and IAM
     *         role ARN.
     */
    public KinesisStreamsInputUpdate kinesisStreamsInputUpdate() {
        return kinesisStreamsInputUpdate;
    }

    /**
     * <p>
     * If an Amazon Kinesis Firehose delivery stream is the streaming source to be updated, provides an updated stream
     * Amazon Resource Name (ARN) and IAM role ARN.
     * </p>
     * 
     * @return If an Amazon Kinesis Firehose delivery stream is the streaming source to be updated, provides an updated
     *         stream Amazon Resource Name (ARN) and IAM role ARN.
     */
    public KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate() {
        return kinesisFirehoseInputUpdate;
    }

    /**
     * <p>
     * Describes the data format on the streaming source, and how record elements on the streaming source map to columns
     * of the in-application stream that is created.
     * </p>
     * 
     * @return Describes the data format on the streaming source, and how record elements on the streaming source map to
     *         columns of the in-application stream that is created.
     */
    public InputSchemaUpdate inputSchemaUpdate() {
        return inputSchemaUpdate;
    }

    /**
     * <p>
     * Describes the parallelism updates (the number in-application streams Amazon Kinesis Analytics creates for the
     * specific streaming source).
     * </p>
     * 
     * @return Describes the parallelism updates (the number in-application streams Amazon Kinesis Analytics creates for
     *         the specific streaming source).
     */
    public InputParallelismUpdate inputParallelismUpdate() {
        return inputParallelismUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputId());
        hashCode = 31 * hashCode + Objects.hashCode(namePrefixUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(inputProcessingConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamsInputUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisFirehoseInputUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(inputSchemaUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(inputParallelismUpdate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputUpdate)) {
            return false;
        }
        InputUpdate other = (InputUpdate) obj;
        return Objects.equals(inputId(), other.inputId()) && Objects.equals(namePrefixUpdate(), other.namePrefixUpdate())
                && Objects.equals(inputProcessingConfigurationUpdate(), other.inputProcessingConfigurationUpdate())
                && Objects.equals(kinesisStreamsInputUpdate(), other.kinesisStreamsInputUpdate())
                && Objects.equals(kinesisFirehoseInputUpdate(), other.kinesisFirehoseInputUpdate())
                && Objects.equals(inputSchemaUpdate(), other.inputSchemaUpdate())
                && Objects.equals(inputParallelismUpdate(), other.inputParallelismUpdate());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (inputId() != null) {
            sb.append("InputId: ").append(inputId()).append(",");
        }
        if (namePrefixUpdate() != null) {
            sb.append("NamePrefixUpdate: ").append(namePrefixUpdate()).append(",");
        }
        if (inputProcessingConfigurationUpdate() != null) {
            sb.append("InputProcessingConfigurationUpdate: ").append(inputProcessingConfigurationUpdate()).append(",");
        }
        if (kinesisStreamsInputUpdate() != null) {
            sb.append("KinesisStreamsInputUpdate: ").append(kinesisStreamsInputUpdate()).append(",");
        }
        if (kinesisFirehoseInputUpdate() != null) {
            sb.append("KinesisFirehoseInputUpdate: ").append(kinesisFirehoseInputUpdate()).append(",");
        }
        if (inputSchemaUpdate() != null) {
            sb.append("InputSchemaUpdate: ").append(inputSchemaUpdate()).append(",");
        }
        if (inputParallelismUpdate() != null) {
            sb.append("InputParallelismUpdate: ").append(inputParallelismUpdate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputId":
            return Optional.of(clazz.cast(inputId()));
        case "NamePrefixUpdate":
            return Optional.of(clazz.cast(namePrefixUpdate()));
        case "InputProcessingConfigurationUpdate":
            return Optional.of(clazz.cast(inputProcessingConfigurationUpdate()));
        case "KinesisStreamsInputUpdate":
            return Optional.of(clazz.cast(kinesisStreamsInputUpdate()));
        case "KinesisFirehoseInputUpdate":
            return Optional.of(clazz.cast(kinesisFirehoseInputUpdate()));
        case "InputSchemaUpdate":
            return Optional.of(clazz.cast(inputSchemaUpdate()));
        case "InputParallelismUpdate":
            return Optional.of(clazz.cast(inputParallelismUpdate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InputUpdate> {
        /**
         * <p>
         * Input ID of the application input to be updated.
         * </p>
         * 
         * @param inputId
         *        Input ID of the application input to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputId(String inputId);

        /**
         * <p>
         * Name prefix for in-application streams that Amazon Kinesis Analytics creates for the specific streaming
         * source.
         * </p>
         * 
         * @param namePrefixUpdate
         *        Name prefix for in-application streams that Amazon Kinesis Analytics creates for the specific
         *        streaming source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namePrefixUpdate(String namePrefixUpdate);

        /**
         * <p>
         * Describes updates for an input processing configuration.
         * </p>
         * 
         * @param inputProcessingConfigurationUpdate
         *        Describes updates for an input processing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputProcessingConfigurationUpdate(InputProcessingConfigurationUpdate inputProcessingConfigurationUpdate);

        /**
         * <p>
         * Describes updates for an input processing configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link InputProcessingConfigurationUpdate.Builder}
         * avoiding the need to create one manually via {@link InputProcessingConfigurationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputProcessingConfigurationUpdate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #inputProcessingConfigurationUpdate(InputProcessingConfigurationUpdate)}.
         * 
         * @param inputProcessingConfigurationUpdate
         *        a consumer that will call methods on {@link InputProcessingConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputProcessingConfigurationUpdate(InputProcessingConfigurationUpdate)
         */
        default Builder inputProcessingConfigurationUpdate(
                Consumer<InputProcessingConfigurationUpdate.Builder> inputProcessingConfigurationUpdate) {
            return inputProcessingConfigurationUpdate(InputProcessingConfigurationUpdate.builder()
                    .apply(inputProcessingConfigurationUpdate).build());
        }

        /**
         * <p>
         * If a Amazon Kinesis stream is the streaming source to be updated, provides an updated stream ARN and IAM role
         * ARN.
         * </p>
         * 
         * @param kinesisStreamsInputUpdate
         *        If a Amazon Kinesis stream is the streaming source to be updated, provides an updated stream ARN and
         *        IAM role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamsInputUpdate(KinesisStreamsInputUpdate kinesisStreamsInputUpdate);

        /**
         * <p>
         * If a Amazon Kinesis stream is the streaming source to be updated, provides an updated stream ARN and IAM role
         * ARN.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisStreamsInputUpdate.Builder} avoiding the
         * need to create one manually via {@link KinesisStreamsInputUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisStreamsInputUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #kinesisStreamsInputUpdate(KinesisStreamsInputUpdate)}.
         * 
         * @param kinesisStreamsInputUpdate
         *        a consumer that will call methods on {@link KinesisStreamsInputUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisStreamsInputUpdate(KinesisStreamsInputUpdate)
         */
        default Builder kinesisStreamsInputUpdate(Consumer<KinesisStreamsInputUpdate.Builder> kinesisStreamsInputUpdate) {
            return kinesisStreamsInputUpdate(KinesisStreamsInputUpdate.builder().apply(kinesisStreamsInputUpdate).build());
        }

        /**
         * <p>
         * If an Amazon Kinesis Firehose delivery stream is the streaming source to be updated, provides an updated
         * stream Amazon Resource Name (ARN) and IAM role ARN.
         * </p>
         * 
         * @param kinesisFirehoseInputUpdate
         *        If an Amazon Kinesis Firehose delivery stream is the streaming source to be updated, provides an
         *        updated stream Amazon Resource Name (ARN) and IAM role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisFirehoseInputUpdate(KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate);

        /**
         * <p>
         * If an Amazon Kinesis Firehose delivery stream is the streaming source to be updated, provides an updated
         * stream Amazon Resource Name (ARN) and IAM role ARN.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisFirehoseInputUpdate.Builder} avoiding the
         * need to create one manually via {@link KinesisFirehoseInputUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisFirehoseInputUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #kinesisFirehoseInputUpdate(KinesisFirehoseInputUpdate)}.
         * 
         * @param kinesisFirehoseInputUpdate
         *        a consumer that will call methods on {@link KinesisFirehoseInputUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisFirehoseInputUpdate(KinesisFirehoseInputUpdate)
         */
        default Builder kinesisFirehoseInputUpdate(Consumer<KinesisFirehoseInputUpdate.Builder> kinesisFirehoseInputUpdate) {
            return kinesisFirehoseInputUpdate(KinesisFirehoseInputUpdate.builder().apply(kinesisFirehoseInputUpdate).build());
        }

        /**
         * <p>
         * Describes the data format on the streaming source, and how record elements on the streaming source map to
         * columns of the in-application stream that is created.
         * </p>
         * 
         * @param inputSchemaUpdate
         *        Describes the data format on the streaming source, and how record elements on the streaming source map
         *        to columns of the in-application stream that is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSchemaUpdate(InputSchemaUpdate inputSchemaUpdate);

        /**
         * <p>
         * Describes the data format on the streaming source, and how record elements on the streaming source map to
         * columns of the in-application stream that is created.
         * </p>
         * This is a convenience that creates an instance of the {@link InputSchemaUpdate.Builder} avoiding the need to
         * create one manually via {@link InputSchemaUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputSchemaUpdate.Builder#build()} is called immediately and its
         * result is passed to {@link #inputSchemaUpdate(InputSchemaUpdate)}.
         * 
         * @param inputSchemaUpdate
         *        a consumer that will call methods on {@link InputSchemaUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputSchemaUpdate(InputSchemaUpdate)
         */
        default Builder inputSchemaUpdate(Consumer<InputSchemaUpdate.Builder> inputSchemaUpdate) {
            return inputSchemaUpdate(InputSchemaUpdate.builder().apply(inputSchemaUpdate).build());
        }

        /**
         * <p>
         * Describes the parallelism updates (the number in-application streams Amazon Kinesis Analytics creates for the
         * specific streaming source).
         * </p>
         * 
         * @param inputParallelismUpdate
         *        Describes the parallelism updates (the number in-application streams Amazon Kinesis Analytics creates
         *        for the specific streaming source).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputParallelismUpdate(InputParallelismUpdate inputParallelismUpdate);

        /**
         * <p>
         * Describes the parallelism updates (the number in-application streams Amazon Kinesis Analytics creates for the
         * specific streaming source).
         * </p>
         * This is a convenience that creates an instance of the {@link InputParallelismUpdate.Builder} avoiding the
         * need to create one manually via {@link InputParallelismUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputParallelismUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #inputParallelismUpdate(InputParallelismUpdate)}.
         * 
         * @param inputParallelismUpdate
         *        a consumer that will call methods on {@link InputParallelismUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputParallelismUpdate(InputParallelismUpdate)
         */
        default Builder inputParallelismUpdate(Consumer<InputParallelismUpdate.Builder> inputParallelismUpdate) {
            return inputParallelismUpdate(InputParallelismUpdate.builder().apply(inputParallelismUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String inputId;

        private String namePrefixUpdate;

        private InputProcessingConfigurationUpdate inputProcessingConfigurationUpdate;

        private KinesisStreamsInputUpdate kinesisStreamsInputUpdate;

        private KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate;

        private InputSchemaUpdate inputSchemaUpdate;

        private InputParallelismUpdate inputParallelismUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(InputUpdate model) {
            inputId(model.inputId);
            namePrefixUpdate(model.namePrefixUpdate);
            inputProcessingConfigurationUpdate(model.inputProcessingConfigurationUpdate);
            kinesisStreamsInputUpdate(model.kinesisStreamsInputUpdate);
            kinesisFirehoseInputUpdate(model.kinesisFirehoseInputUpdate);
            inputSchemaUpdate(model.inputSchemaUpdate);
            inputParallelismUpdate(model.inputParallelismUpdate);
        }

        public final String getInputId() {
            return inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        public final String getNamePrefixUpdate() {
            return namePrefixUpdate;
        }

        @Override
        public final Builder namePrefixUpdate(String namePrefixUpdate) {
            this.namePrefixUpdate = namePrefixUpdate;
            return this;
        }

        public final void setNamePrefixUpdate(String namePrefixUpdate) {
            this.namePrefixUpdate = namePrefixUpdate;
        }

        public final InputProcessingConfigurationUpdate.Builder getInputProcessingConfigurationUpdate() {
            return inputProcessingConfigurationUpdate != null ? inputProcessingConfigurationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder inputProcessingConfigurationUpdate(
                InputProcessingConfigurationUpdate inputProcessingConfigurationUpdate) {
            this.inputProcessingConfigurationUpdate = inputProcessingConfigurationUpdate;
            return this;
        }

        public final void setInputProcessingConfigurationUpdate(
                InputProcessingConfigurationUpdate.BuilderImpl inputProcessingConfigurationUpdate) {
            this.inputProcessingConfigurationUpdate = inputProcessingConfigurationUpdate != null ? inputProcessingConfigurationUpdate
                    .build() : null;
        }

        public final KinesisStreamsInputUpdate.Builder getKinesisStreamsInputUpdate() {
            return kinesisStreamsInputUpdate != null ? kinesisStreamsInputUpdate.toBuilder() : null;
        }

        @Override
        public final Builder kinesisStreamsInputUpdate(KinesisStreamsInputUpdate kinesisStreamsInputUpdate) {
            this.kinesisStreamsInputUpdate = kinesisStreamsInputUpdate;
            return this;
        }

        public final void setKinesisStreamsInputUpdate(KinesisStreamsInputUpdate.BuilderImpl kinesisStreamsInputUpdate) {
            this.kinesisStreamsInputUpdate = kinesisStreamsInputUpdate != null ? kinesisStreamsInputUpdate.build() : null;
        }

        public final KinesisFirehoseInputUpdate.Builder getKinesisFirehoseInputUpdate() {
            return kinesisFirehoseInputUpdate != null ? kinesisFirehoseInputUpdate.toBuilder() : null;
        }

        @Override
        public final Builder kinesisFirehoseInputUpdate(KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate) {
            this.kinesisFirehoseInputUpdate = kinesisFirehoseInputUpdate;
            return this;
        }

        public final void setKinesisFirehoseInputUpdate(KinesisFirehoseInputUpdate.BuilderImpl kinesisFirehoseInputUpdate) {
            this.kinesisFirehoseInputUpdate = kinesisFirehoseInputUpdate != null ? kinesisFirehoseInputUpdate.build() : null;
        }

        public final InputSchemaUpdate.Builder getInputSchemaUpdate() {
            return inputSchemaUpdate != null ? inputSchemaUpdate.toBuilder() : null;
        }

        @Override
        public final Builder inputSchemaUpdate(InputSchemaUpdate inputSchemaUpdate) {
            this.inputSchemaUpdate = inputSchemaUpdate;
            return this;
        }

        public final void setInputSchemaUpdate(InputSchemaUpdate.BuilderImpl inputSchemaUpdate) {
            this.inputSchemaUpdate = inputSchemaUpdate != null ? inputSchemaUpdate.build() : null;
        }

        public final InputParallelismUpdate.Builder getInputParallelismUpdate() {
            return inputParallelismUpdate != null ? inputParallelismUpdate.toBuilder() : null;
        }

        @Override
        public final Builder inputParallelismUpdate(InputParallelismUpdate inputParallelismUpdate) {
            this.inputParallelismUpdate = inputParallelismUpdate;
            return this;
        }

        public final void setInputParallelismUpdate(InputParallelismUpdate.BuilderImpl inputParallelismUpdate) {
            this.inputParallelismUpdate = inputParallelismUpdate != null ? inputParallelismUpdate.build() : null;
        }

        @Override
        public InputUpdate build() {
            return new InputUpdate(this);
        }
    }
}
