/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputProcessingConfigurationUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes updates to an <a>InputProcessingConfiguration</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InputProcessingConfigurationUpdate implements StructuredPojo,
        ToCopyableBuilder<InputProcessingConfigurationUpdate.Builder, InputProcessingConfigurationUpdate> {
    private final InputLambdaProcessorUpdate inputLambdaProcessorUpdate;

    private InputProcessingConfigurationUpdate(BuilderImpl builder) {
        this.inputLambdaProcessorUpdate = builder.inputLambdaProcessorUpdate;
    }

    /**
     * <p>
     * Provides update information for an <a>InputLambdaProcessor</a>.
     * </p>
     * 
     * @return Provides update information for an <a>InputLambdaProcessor</a>.
     */
    public InputLambdaProcessorUpdate inputLambdaProcessorUpdate() {
        return inputLambdaProcessorUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputLambdaProcessorUpdate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputProcessingConfigurationUpdate)) {
            return false;
        }
        InputProcessingConfigurationUpdate other = (InputProcessingConfigurationUpdate) obj;
        return Objects.equals(inputLambdaProcessorUpdate(), other.inputLambdaProcessorUpdate());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (inputLambdaProcessorUpdate() != null) {
            sb.append("InputLambdaProcessorUpdate: ").append(inputLambdaProcessorUpdate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputLambdaProcessorUpdate":
            return Optional.of(clazz.cast(inputLambdaProcessorUpdate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputProcessingConfigurationUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InputProcessingConfigurationUpdate> {
        /**
         * <p>
         * Provides update information for an <a>InputLambdaProcessor</a>.
         * </p>
         * 
         * @param inputLambdaProcessorUpdate
         *        Provides update information for an <a>InputLambdaProcessor</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputLambdaProcessorUpdate(InputLambdaProcessorUpdate inputLambdaProcessorUpdate);

        /**
         * <p>
         * Provides update information for an <a>InputLambdaProcessor</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link InputLambdaProcessorUpdate.Builder} avoiding the
         * need to create one manually via {@link InputLambdaProcessorUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputLambdaProcessorUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #inputLambdaProcessorUpdate(InputLambdaProcessorUpdate)}.
         * 
         * @param inputLambdaProcessorUpdate
         *        a consumer that will call methods on {@link InputLambdaProcessorUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputLambdaProcessorUpdate(InputLambdaProcessorUpdate)
         */
        default Builder inputLambdaProcessorUpdate(Consumer<InputLambdaProcessorUpdate.Builder> inputLambdaProcessorUpdate) {
            return inputLambdaProcessorUpdate(InputLambdaProcessorUpdate.builder().apply(inputLambdaProcessorUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InputLambdaProcessorUpdate inputLambdaProcessorUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(InputProcessingConfigurationUpdate model) {
            inputLambdaProcessorUpdate(model.inputLambdaProcessorUpdate);
        }

        public final InputLambdaProcessorUpdate.Builder getInputLambdaProcessorUpdate() {
            return inputLambdaProcessorUpdate != null ? inputLambdaProcessorUpdate.toBuilder() : null;
        }

        @Override
        public final Builder inputLambdaProcessorUpdate(InputLambdaProcessorUpdate inputLambdaProcessorUpdate) {
            this.inputLambdaProcessorUpdate = inputLambdaProcessorUpdate;
            return this;
        }

        public final void setInputLambdaProcessorUpdate(InputLambdaProcessorUpdate.BuilderImpl inputLambdaProcessorUpdate) {
            this.inputLambdaProcessorUpdate = inputLambdaProcessorUpdate != null ? inputLambdaProcessorUpdate.build() : null;
        }

        @Override
        public InputProcessingConfigurationUpdate build() {
            return new InputProcessingConfigurationUpdate(this);
        }
    }
}
